/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.facade;

import com.atherys.towns.AtherysTowns;
import com.atherys.towns.TownsConfig;
import com.atherys.towns.api.command.TownsCommandException;
import com.atherys.towns.facade.TownFacade;
import com.atherys.towns.facade.TownsMessagingFacade;
import com.atherys.towns.model.entity.Resident;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.service.ResidentService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

@Singleton
public class TownSpawnFacade {
    @Inject
    private TownsConfig config;
    @Inject
    private ResidentService residentService;
    @Inject
    private TownFacade townFacade;
    @Inject
    private TownsMessagingFacade townsMsg;
    private final Task task = Task.builder().execute(() -> {
        if (this.config.TOWN.TOWN_WARMUP == 0) {
            return;
        }
        Map<Player, Resident> residents = Sponge.getServer().getOnlinePlayers().stream().collect(Collectors.toMap(p -> p, this.residentService::getOrCreate));
        residents.forEach((player, resident) -> {
            if (resident.getWarmupSecondsLeft() > 0) {
                resident.setWarmupSecondsLeft(resident.getWarmupSecondsLeft() - 1);
                if (resident.getWarmupSecondsLeft() == 0) {
                    this.teleport((Player)player, (Resident)resident);
                }
            }
        });
    }).interval(1L, TimeUnit.SECONDS).name("atherystowns-warmups").submit((Object)AtherysTowns.getInstance());

    public void spawnPlayerTown(Player source) throws TownsCommandException {
        Town town = this.townFacade.getPlayerTown(source);
        Resident resident = this.residentService.getOrCreate((User)source);
        Duration timeLeft = Duration.between(resident.getLastTownSpawn().plus(this.config.TOWN.TOWN_COOLDOWN, ChronoUnit.MINUTES), LocalDateTime.now());
        if (timeLeft.isNegative()) {
            long minutes = Math.round((double)timeLeft.abs().getSeconds() / 60.0);
            String unit = minutes == 1L ? " minute" : " minutes";
            throw new TownsCommandException(minutes + unit + " left on cooldown.");
        }
        if (this.config.TOWN.TOWN_WARMUP > 0) {
            resident.setWarmupSecondsLeft(this.config.TOWN.TOWN_WARMUP);
            this.townsMsg.info((MessageReceiver)source, new Object[]{"Teleporting in ", TextColors.GOLD, this.config.TOWN.TOWN_WARMUP, TextColors.DARK_GREEN, " seconds."});
        } else {
            this.teleport(source, resident);
        }
    }

    private void teleport(Player source, Resident resident) {
        source.setTransformSafely(resident.getTown().getSpawn());
        if (this.config.TOWN.TOWN_COOLDOWN > 0) {
            this.residentService.setLastTownSpawn(resident, LocalDateTime.now());
        }
    }

    public void onPlayerMove(Player source) {
        Resident resident = this.residentService.getOrCreate((User)source);
        if (resident.getWarmupSecondsLeft() > 0) {
            this.townsMsg.error((MessageReceiver)source, new Object[]{"Teleportation cancelled!"});
            resident.setWarmupSecondsLeft(0);
        }
    }
}

