/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.facade;

import com.atherys.core.economy.Economy;
import com.atherys.core.utils.AbstractMessagingFacade;
import com.atherys.towns.AtherysTowns;
import com.atherys.towns.TownsConfig;
import com.atherys.towns.facade.NationFacade;
import com.atherys.towns.facade.TownFacade;
import com.atherys.towns.model.entity.Nation;
import com.atherys.towns.model.entity.Town;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.economy.account.Account;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;

@Singleton
public class TownsMessagingFacade
extends AbstractMessagingFacade {
    @Inject
    private TownsConfig config;
    @Inject
    private NationFacade nationFacade;
    @Inject
    private TownFacade townFacade;

    public TownsMessagingFacade() {
        super("Towns");
    }

    public void broadcastInfo(Object ... message) {
        Sponge.getServer().getBroadcastChannel().send(this.formatInfo(message));
    }

    public void broadcastError(Object ... message) {
        Sponge.getServer().getBroadcastChannel().send(this.formatError(message));
    }

    public void broadcastNationInfo(Nation nation, Object ... message) {
        Text formattedMessage = this.formatInfo(message);
        this.nationFacade.getOnlineNationMembers(nation).stream().forEach(player -> player.sendMessage(formattedMessage));
    }

    public void broadcastTownInfo(Town town, Object ... message) {
        Text formattedMessage = this.formatInfo(message);
        this.townFacade.getOnlineTownMembers(town).stream().forEach(player -> player.sendMessage(formattedMessage));
    }

    public void broadcastTownError(Town town, Object ... message) {
        Text formattedMessage = this.formatError(message);
        this.townFacade.getOnlineTownMembers(town).stream().forEach(player -> player.sendMessage(formattedMessage));
    }

    public Text renderBoolean(boolean value, boolean upperCase) {
        if (value) {
            return Text.of((Object[])new Object[]{TextColors.GREEN, upperCase ? "True" : "true"});
        }
        return Text.of((Object[])new Object[]{TextColors.RED, upperCase ? "False" : "false"});
    }

    public int getPadding(int length) {
        if (length < 10) {
            return 18;
        }
        if (length < 20) {
            return 14;
        }
        if (length < 30) {
            return 8;
        }
        if (length < 40) {
            return 4;
        }
        return 2;
    }

    public Text createTownsHeader(String subjectName) {
        int padding = this.getPadding(subjectName.length());
        String trimmedName = subjectName;
        if (padding < 4) {
            trimmedName = subjectName.substring(0, 41) + "...";
        }
        return Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GRAY, "[]", StringUtils.repeat((String)"=", (int)padding), "[ "})}).append(new Text[]{Text.of((Object[])new Object[]{TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.GOLD, subjectName})), TextColors.GOLD, trimmedName})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GRAY, " ]", StringUtils.repeat((String)"=", (int)padding), "[]", Text.NEW_LINE})}).build();
    }

    public Text renderBank(String identifier) {
        if (AtherysTowns.economyIsEnabled()) {
            return Economy.getAccount((String)identifier).map(this::renderBank).orElse(Text.EMPTY);
        }
        return Text.EMPTY;
    }

    public Text renderBank(UUID id) {
        if (AtherysTowns.economyIsEnabled()) {
            return Economy.getAccount((UUID)id).map(this::renderBank).orElse(Text.EMPTY);
        }
        return Text.EMPTY;
    }

    public Text renderBank(Account account) {
        if (AtherysTowns.economyIsEnabled()) {
            return Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Bank: ", TextColors.GOLD, this.config.DEFAULT_CURRENCY.format(account.getBalance(this.config.DEFAULT_CURRENCY))});
        }
        return Text.EMPTY;
    }
}

