/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.listener;

import com.atherys.core.utils.EntityUtils;
import com.atherys.towns.TownsConfig;
import com.atherys.towns.api.event.PlayerVoteEvent;
import com.atherys.towns.facade.PlotBorderFacade;
import com.atherys.towns.facade.PlotFacade;
import com.atherys.towns.facade.PollFacade;
import com.atherys.towns.facade.ResidentFacade;
import com.atherys.towns.facade.TownFacade;
import com.atherys.towns.facade.TownRaidFacade;
import com.atherys.towns.facade.TownSpawnFacade;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.RespawnPlayerEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.world.World;

@Singleton
public class PlayerListener {
    @Inject
    private PlotFacade plotFacade;
    @Inject
    private TownSpawnFacade townSpawnFacade;
    @Inject
    private TownFacade townFacade;
    @Inject
    private TownsConfig config;
    @Inject
    private ResidentFacade residentFacade;
    @Inject
    private PollFacade pollFacade;
    @Inject
    private PlotBorderFacade plotBorderFacade;
    @Inject
    private TownRaidFacade townRaidFacade;

    @Listener
    public void onPlayerMove(MoveEntityEvent event, @Root Player player) {
        if (!event.getFromTransform().getPosition().toInt().equals((Object)event.getToTransform().getPosition().toInt())) {
            this.plotFacade.onPlayerMove((Transform<World>)event.getFromTransform(), (Transform<World>)event.getToTransform(), (Player)event.getTargetEntity());
            this.plotBorderFacade.onPlayerMove((Transform<World>)event.getFromTransform(), (Transform<World>)event.getToTransform(), (Player)event.getTargetEntity());
            this.townSpawnFacade.onPlayerMove(player);
        }
    }

    @Listener
    public void onPlayerSpawn(RespawnPlayerEvent event) {
        if (!this.townRaidFacade.onPlayerSpawn(event) && this.config.SPAWN_IN_TOWN) {
            this.residentFacade.onPlayerSpawn(event);
        }
    }

    @Listener
    public void onPlayerLogin(ClientConnectionEvent.Join event, @Root Player player) {
        this.residentFacade.onLogin(player);
    }

    @Listener
    public void onPlayerDamage(DamageEntityEvent event, @Root EntityDamageSource source, @Getter(value="getTargetEntity") Player target) {
        EntityUtils.playerAttackedEntity((EntityDamageSource)source).ifPresent(attacker -> this.townFacade.onPlayerDamage(event, (Player)attacker, target));
    }

    @Listener
    public void onPlayerVote(PlayerVoteEvent event) {
        this.pollFacade.onPlayerVote(event);
    }
}

