/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.listener;

import com.atherys.towns.api.permission.world.WorldPermissions;
import com.atherys.towns.facade.PlotFacade;
import com.google.inject.Inject;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.CollideBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.CollideEntityEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class ProtectionListener {
    @Inject
    PlotFacade plotFacade;

    public boolean isRedstone(BlockType blockType) {
        return blockType.getDefaultState().supports(Keys.POWERED) || blockType.getDefaultState().supports(Keys.POWER);
    }

    public boolean isTileEntity(BlockSnapshot snapshot) {
        return snapshot.getLocation().map(location -> location.getTileEntity().isPresent()).orElse(false);
    }

    public boolean isDoor(BlockType blockType) {
        return blockType.getDefaultState().supports(Keys.OPEN);
    }

    @Listener
    public void onBlockPlace(ChangeBlockEvent.Place event, @Root Player player) {
        event.getTransactions().forEach(blockSnapshotTransaction -> ((BlockSnapshot)blockSnapshotTransaction.getOriginal()).getLocation().ifPresent(location -> this.plotFacade.plotAccessCheck((Cancellable)event, (User)player, WorldPermissions.BUILD, (Location<World>)location.copy().add(0.5, 0.5, 0.5), true)));
    }

    @Listener
    public void onBlockBreak(ChangeBlockEvent.Break event, @Root Player player) {
        event.getTransactions().forEach(blockSnapshotTransaction -> ((BlockSnapshot)blockSnapshotTransaction.getOriginal()).getLocation().ifPresent(location -> this.plotFacade.plotAccessCheck((Cancellable)event, (User)player, WorldPermissions.DESTROY, (Location<World>)location.copy().add(0.5, 0.5, 0.5), true)));
    }

    @Listener
    public void onBlockChange(ChangeBlockEvent.Modify event, @Root Player player) {
        event.getTransactions().forEach(blockSnapshotTransaction -> ((BlockSnapshot)blockSnapshotTransaction.getOriginal()).getLocation().ifPresent(location -> {
            BlockType blockType = ((BlockSnapshot)blockSnapshotTransaction.getOriginal()).getState().getType();
            if (this.isDoor(blockType) || this.isRedstone(blockType) || this.isTileEntity((BlockSnapshot)blockSnapshotTransaction.getOriginal())) {
                return;
            }
            this.plotFacade.plotAccessCheck((Cancellable)event, (User)player, WorldPermissions.BUILD, (Location<World>)location.copy().add(0.5, 0.5, 0.5), true);
        }));
    }

    @Listener
    public void onBlockInteract(InteractBlockEvent event, @Root Player player) {
        event.getTargetBlock().getLocation().ifPresent(location -> {
            BlockType blockType = event.getTargetBlock().getState().getType();
            if (this.isTileEntity(event.getTargetBlock())) {
                this.plotFacade.plotAccessCheck((Cancellable)event, (User)player, WorldPermissions.INTERACT_TILE_ENTITIES, (Location<World>)location.copy().add(0.5, 0.5, 0.5), true);
            }
            if (this.isDoor(blockType)) {
                this.plotFacade.plotAccessCheck((Cancellable)event, (User)player, WorldPermissions.INTERACT_DOORS, (Location<World>)location.copy().add(0.5, 0.5, 0.5), true);
            }
            if (this.isRedstone(blockType) && !this.isDoor(blockType)) {
                this.plotFacade.plotAccessCheck((Cancellable)event, (User)player, WorldPermissions.INTERACT_REDSTONE, (Location<World>)location.copy().add(0.5, 0.5, 0.5), true);
            }
            if (blockType.equals(BlockTypes.TNT)) {
                this.plotFacade.plotAccessCheck((Cancellable)event, (User)player, WorldPermissions.INTERACT_ENTITIES, (Location<World>)location.copy().add(0.5, 0.5, 0.5), true);
            }
        });
    }

    @Listener
    public void onEntityInteract(InteractEntityEvent event, @Root Player player) {
        if (!(event.getTargetEntity() instanceof Player) && (event instanceof InteractEntityEvent.Primary.MainHand || event instanceof InteractEntityEvent.Secondary.MainHand)) {
            this.plotFacade.plotAccessCheck((Cancellable)event, (User)player, WorldPermissions.INTERACT_ENTITIES, (Location<World>)event.getTargetEntity().getLocation(), false);
        }
    }

    @Listener
    public void onCollideBlock(CollideBlockEvent event, @Root Player player) {
        if (this.isRedstone(event.getTargetBlock().getType())) {
            this.plotFacade.plotAccessCheck((Cancellable)event, (User)player, WorldPermissions.INTERACT_REDSTONE, (Location<World>)event.getTargetLocation(), false);
        }
    }

    @Listener
    public void onEntityDamage(CollideEntityEvent.Impact event) {
        event.getContext().get(EventContextKeys.OWNER).filter(user -> user.getPlayer().isPresent()).map(User::getPlayer).ifPresent(player -> {
            if (event.getEntities().stream().noneMatch(entity -> entity instanceof Player)) {
                event.getEntities().forEach(entity -> this.plotFacade.plotAccessCheck((Cancellable)event, (User)player.get(), WorldPermissions.INTERACT_ENTITIES, (Location<World>)entity.getLocation(), true));
            }
        });
    }
}

