/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.model.entity;

import com.atherys.core.db.Identifiable;
import com.atherys.towns.model.entity.NationPlot;
import com.atherys.towns.model.entity.Resident;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.persistence.converter.TextColorConverter;
import com.atherys.towns.persistence.converter.TextConverter;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Version;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColor;

@Entity
public class Nation
implements Identifiable<Long> {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    private String name;
    @Convert(converter=TextColorConverter.class)
    private TextColor color;
    @Convert(converter=TextConverter.class)
    private Text description;
    @OneToOne
    private Resident leader;
    @OneToOne
    private Town capital;
    @OneToMany(mappedBy="nation", fetch=FetchType.EAGER)
    private Set<Town> towns = new HashSet<Town>();
    @ManyToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST}, fetch=FetchType.EAGER)
    @JoinTable(name="nation_allies", joinColumns={@JoinColumn(name="nation_id")}, inverseJoinColumns={@JoinColumn(name="ally_nation_id")})
    private Set<Nation> allies = new HashSet<Nation>();
    @ManyToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST}, fetch=FetchType.EAGER)
    @JoinTable(name="nation_enemies", joinColumns={@JoinColumn(name="nation_id")}, inverseJoinColumns={@JoinColumn(name="enemy_nation_id")})
    private Set<Nation> enemies = new HashSet<Nation>();
    @OneToMany(mappedBy="nation", fetch=FetchType.EAGER)
    private Set<NationPlot> plots = new HashSet<NationPlot>();
    private boolean joinable;
    private double tax;
    private UUID bank;
    @Version
    private int version;

    @Nonnull
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Text getDescription() {
        return this.description;
    }

    public void setDescription(Text description) {
        this.description = description;
    }

    public Set<Town> getTowns() {
        return this.towns;
    }

    public void setTowns(Set<Town> towns) {
        this.towns = towns;
    }

    public void addTown(Town town) {
        this.towns.add(town);
    }

    public void removeTown(Town town) {
        this.towns.remove(town);
    }

    public Resident getLeader() {
        return this.leader;
    }

    public void setLeader(Resident resident) {
        this.leader = resident;
    }

    public Town getCapital() {
        return this.capital;
    }

    public void setCapital(Town town) {
        this.capital = town;
    }

    public Set<Nation> getAllies() {
        return this.allies;
    }

    public void setAllies(Set<Nation> allies) {
        this.allies = allies;
    }

    public void addAlly(Nation nation) {
        this.allies.add(nation);
    }

    public void removeAlly(Nation nation) {
        this.allies.remove(nation);
    }

    public Set<Nation> getEnemies() {
        return this.enemies;
    }

    public void setEnemies(Set<Nation> enemies) {
        this.enemies = enemies;
    }

    public void addEnemy(Nation nation) {
        this.enemies.add(nation);
    }

    public void removeEnemy(Nation nation) {
        this.enemies.remove(nation);
    }

    public boolean isJoinable() {
        return this.joinable;
    }

    public void setJoinable(boolean freelyJoinable) {
        this.joinable = freelyJoinable;
    }

    public double getTax() {
        return this.tax;
    }

    public void setTax(double tax) {
        this.tax = tax;
    }

    public UUID getBank() {
        return this.bank;
    }

    public void setBank(UUID bank) {
        this.bank = bank;
    }

    public Set<NationPlot> getPlots() {
        return this.plots;
    }

    public void setPlots(Set<NationPlot> plots) {
        this.plots = plots;
    }

    public void addPlot(NationPlot plot) {
        this.plots.add(plot);
    }

    public void removePlot(NationPlot plot) {
        this.plots.remove(plot);
    }

    protected int getVersion() {
        return this.version;
    }

    protected void setVersion(int version) {
        this.version = version;
    }

    public TextColor getColor() {
        return this.color;
    }

    public void setColor(TextColor color) {
        this.color = color;
    }
}

