/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.model.entity;

import com.atherys.core.db.Identifiable;
import com.atherys.core.db.SpongeIdentifiable;
import com.atherys.towns.model.entity.Town;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.persistence.CascadeType;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.persistence.Version;

@Entity
public class Resident
implements SpongeIdentifiable,
Identifiable<UUID> {
    @Id
    private UUID id;
    private String name;
    private String title;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="town_id")
    private Town town;
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="resident_friends", joinColumns={@JoinColumn(name="resident_id")}, inverseJoinColumns={@JoinColumn(name="friend_id")})
    private Set<Resident> friends = new HashSet<Resident>();
    @ElementCollection(fetch=FetchType.EAGER)
    private Set<String> townRoleIds = new HashSet<String>();
    @ElementCollection(fetch=FetchType.EAGER)
    private Set<String> nationRoleIds = new HashSet<String>();
    private LocalDateTime registeredOn;
    private LocalDateTime lastLogin;
    private LocalDateTime lastTownSpawn;
    @Transient
    private int warmupSecondsLeft;
    @Version
    private int version;

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Town getTown() {
        return this.town;
    }

    public void setTown(Town town) {
        this.town = town;
    }

    public Set<Resident> getFriends() {
        return this.friends;
    }

    public void setFriends(Set<Resident> friends) {
        this.friends = friends;
    }

    public void addFriend(Resident friend) {
        this.friends.add(friend);
    }

    public void removeFriend(Resident friend) {
        this.friends.remove(friend);
    }

    public Set<String> getTownRoleIds() {
        return this.townRoleIds;
    }

    public void setTownRoles(Set<String> townRoles) {
        this.townRoleIds = townRoles;
    }

    public Set<String> getNationRoleIds() {
        return this.nationRoleIds;
    }

    public void setNationRoles(Set<String> nationRoles) {
        this.nationRoleIds = nationRoles;
    }

    public LocalDateTime getRegisteredOn() {
        return this.registeredOn;
    }

    public void setRegisteredOn(LocalDateTime registeredOn) {
        this.registeredOn = registeredOn;
    }

    public LocalDateTime getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(LocalDateTime lastLogin) {
        this.lastLogin = lastLogin;
    }

    public LocalDateTime getLastTownSpawn() {
        return this.lastTownSpawn;
    }

    public void setLastTownSpawn(LocalDateTime lastTownSpawn) {
        this.lastTownSpawn = lastTownSpawn;
    }

    public int getWarmupSecondsLeft() {
        return this.warmupSecondsLeft;
    }

    public void setWarmupSecondsLeft(int warmupSecondsLeft) {
        this.warmupSecondsLeft = warmupSecondsLeft;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

