/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.model.entity;

import com.atherys.core.db.Identifiable;
import com.atherys.core.db.converter.TransformConverter;
import com.atherys.towns.model.entity.Nation;
import com.atherys.towns.model.entity.Resident;
import com.atherys.towns.model.entity.TownPlot;
import com.atherys.towns.persistence.converter.TextColorConverter;
import com.atherys.towns.persistence.converter.TextConverter;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.world.World;

@Entity
public class Town
implements Identifiable<Long> {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    private String name;
    @Convert(converter=TextConverter.class)
    private Text description;
    @Convert(converter=TextConverter.class)
    private Text motd;
    @Convert(converter=TextColorConverter.class)
    private TextColor color;
    @OneToOne
    private Resident leader;
    @OneToOne
    private Nation nation;
    private UUID world;
    @Convert(converter=TransformConverter.class)
    private Transform<World> spawn;
    @OneToMany(mappedBy="town", fetch=FetchType.EAGER)
    private Set<Resident> residents = new HashSet<Resident>();
    @OneToMany(mappedBy="town", fetch=FetchType.EAGER)
    private Set<TownPlot> plots = new HashSet<TownPlot>();
    @Transient
    private Map<TownPlot, Set<TownPlot>> plotGraphAdjList;
    private int maxSize;
    private boolean freelyJoinable;
    private boolean pvpEnabled;
    private UUID bank;
    private LocalDateTime lastTaxDate;
    private LocalDateTime lastRaidCreationDate;
    private int taxFailedCount;
    private double debt;
    private boolean taxable;
    @Version
    private int version;

    @Nonnull
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Text getDescription() {
        return this.description;
    }

    public void setDescription(Text description) {
        this.description = description;
    }

    public Text getMotd() {
        return this.motd;
    }

    public void setMotd(Text motd) {
        this.motd = motd;
    }

    public Resident getLeader() {
        return this.leader;
    }

    public void setLeader(Resident leader) {
        this.leader = leader;
    }

    public Nation getNation() {
        return this.nation;
    }

    public void setNation(Nation nation) {
        this.nation = nation;
    }

    public UUID getWorld() {
        return this.world;
    }

    public void setWorld(UUID world) {
        this.world = world;
    }

    public Transform<World> getSpawn() {
        return this.spawn;
    }

    public void setSpawn(Transform<World> spawn) {
        this.spawn = spawn;
    }

    public Set<Resident> getResidents() {
        return this.residents;
    }

    public void setResidents(Set<Resident> residents) {
        this.residents = residents;
    }

    public void addResident(Resident resident) {
        this.residents.add(resident);
    }

    public void removeResident(Resident resident) {
        this.residents.remove(resident);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public Set<TownPlot> getPlots() {
        return this.plots;
    }

    public void setPlots(Set<TownPlot> plots) {
        this.plots = plots;
    }

    public void addPlot(TownPlot plot) {
        this.plots.add(plot);
    }

    public void removePlot(TownPlot plot) {
        this.plots.remove(plot);
    }

    public boolean isFreelyJoinable() {
        return this.freelyJoinable;
    }

    public void setFreelyJoinable(boolean freelyJoinable) {
        this.freelyJoinable = freelyJoinable;
    }

    public boolean isPvpEnabled() {
        return this.pvpEnabled;
    }

    public void setPvpEnabled(boolean pvpEnabled) {
        this.pvpEnabled = pvpEnabled;
    }

    public TextColor getColor() {
        return this.color;
    }

    public void setColor(TextColor color) {
        this.color = color;
    }

    public Map<TownPlot, Set<TownPlot>> getPlotGraphAdjList() {
        return this.plotGraphAdjList;
    }

    public void setPlotGraphAdjList(Map<TownPlot, Set<TownPlot>> plotGraphAdjList) {
        this.plotGraphAdjList = plotGraphAdjList;
    }

    protected int getVersion() {
        return this.version;
    }

    protected void setVersion(int version) {
        this.version = version;
    }

    public UUID getBank() {
        return this.bank;
    }

    public void setBank(UUID bank) {
        this.bank = bank;
    }

    public Optional<LocalDateTime> getLastRaidCreationDate() {
        return Optional.ofNullable(this.lastRaidCreationDate);
    }

    public void setLastRaidCreationDate(LocalDateTime lastRaidCreationDate) {
        this.lastRaidCreationDate = lastRaidCreationDate;
    }

    public LocalDateTime getLastTaxDate() {
        return this.lastTaxDate;
    }

    public void setLastTaxDate(LocalDateTime lastTaxDate) {
        this.lastTaxDate = lastTaxDate;
    }

    public int getTaxFailedCount() {
        return this.taxFailedCount;
    }

    public void setTaxFailedCount(int taxFailedCount) {
        this.taxFailedCount = taxFailedCount;
    }

    public double getDebt() {
        return this.debt;
    }

    public void setDebt(double debt) {
        this.debt = debt;
    }

    public boolean isTaxable() {
        return this.taxable;
    }

    public void setTaxable(boolean taxable) {
        this.taxable = taxable;
    }
}

