/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.persistence;

import com.atherys.core.db.CachedHibernateRepository;
import com.atherys.core.db.Identifiable;
import com.atherys.towns.model.entity.Nation;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.persistence.cache.TownsCache;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Optional;

@Singleton
public class NationRepository
extends CachedHibernateRepository<Nation, Long> {
    private TownsCache townsCache;

    @Inject
    protected NationRepository(TownsCache townsCache) {
        super(Nation.class);
        this.cache = townsCache.getNationCache();
        this.townsCache = townsCache;
    }

    public void initCache() {
        this.townsCache.getResidentCache().getAll().forEach(resident -> {
            Town town = resident.getTown();
            if (town != null && town.getNation() != null) {
                this.cache.add((Identifiable)town.getNation());
            }
        });
    }

    public Collection<Nation> getAll() {
        return this.cache.getAll();
    }

    public Optional<Nation> findByName(String nationName) {
        return this.cache.findOne(n -> n.getName().equalsIgnoreCase(nationName));
    }
}

