/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.persistence;

import com.atherys.core.db.CachedHibernateRepository;
import com.atherys.core.db.Identifiable;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.persistence.cache.TownsCache;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Optional;

@Singleton
public class TownRepository
extends CachedHibernateRepository<Town, Long> {
    @Inject
    private TownsCache townsCache;

    @Inject
    protected TownRepository(TownsCache townsCache) {
        super(Town.class);
        this.cache = townsCache.getTownCache();
        this.townsCache = townsCache;
    }

    public Optional<Town> findByName(String townName) {
        return this.cache.findOne(t -> t.getName().equalsIgnoreCase(townName));
    }

    public void initCache() {
        this.townsCache.getResidentCache().getAll().forEach(resident -> {
            Town town = resident.getTown();
            if (town != null) {
                this.cache.add((Identifiable)town);
            }
        });
    }

    public Collection<Town> getAll() {
        return this.townsCache.getTownCache().getAll();
    }
}

