/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.persistence.cache;

import com.atherys.core.db.Identifiable;
import com.atherys.core.db.cache.SimpleCache;
import com.atherys.towns.model.entity.TownPlot;
import com.atherys.towns.service.PlotService;
import com.flowpowered.math.vector.Vector2i;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TownPlotCache
extends SimpleCache<TownPlot, Long> {
    private final Map<Vector2i, Set<TownPlot>> plotChunkCache = new HashMap<Vector2i, Set<TownPlot>>();

    public Set<TownPlot> getPlotsOverlappingChunk(Vector2i chunkCoordinate) {
        return this.plotChunkCache.getOrDefault(chunkCoordinate, new HashSet());
    }

    public void add(TownPlot plot) {
        super.add((Identifiable)plot);
        PlotService.getChunksOverlappedByPlot(plot).forEach(chunkCoordinate -> {
            Set<TownPlot> plots = this.plotChunkCache.get(chunkCoordinate);
            if (plots == null) {
                plots = new HashSet<TownPlot>();
            }
            plots.add(plot);
            this.plotChunkCache.put((Vector2i)chunkCoordinate, plots);
        });
    }

    public void remove(TownPlot plot) {
        super.remove((Identifiable)plot);
        PlotService.getChunksOverlappedByPlot(plot).forEach(chunkCoordinate -> {
            Set<TownPlot> plots = this.plotChunkCache.get(chunkCoordinate);
            if (plots != null) {
                plots.remove(plot);
            }
        });
    }
}

