/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.persistence.cache;

import com.atherys.core.db.cache.Cache;
import com.atherys.core.db.cache.SimpleCache;
import com.atherys.towns.model.entity.Nation;
import com.atherys.towns.model.entity.NationPlot;
import com.atherys.towns.model.entity.Resident;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.persistence.NationPlotRepository;
import com.atherys.towns.persistence.NationRepository;
import com.atherys.towns.persistence.ResidentRepository;
import com.atherys.towns.persistence.TownPlotRepository;
import com.atherys.towns.persistence.TownRepository;
import com.atherys.towns.persistence.cache.TownPlotCache;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.UUID;

@Singleton
public class TownsCache {
    @Inject
    private Provider<ResidentRepository> residentRepository;
    @Inject
    private Provider<TownPlotRepository> townPlotRepository;
    @Inject
    private Provider<TownRepository> townRepository;
    @Inject
    private Provider<NationRepository> nationRepository;
    @Inject
    private Provider<NationPlotRepository> nationPlotRepository;
    private Cache<Resident, UUID> residentCache = new SimpleCache();
    private TownPlotCache townPlotCache = new TownPlotCache();
    private Cache<NationPlot, Long> nationPlotCache = new SimpleCache();
    private Cache<Town, Long> townCache = new SimpleCache();
    private Cache<Nation, Long> nationCache = new SimpleCache();

    public void initCache() {
        ((ResidentRepository)((Object)this.residentRepository.get())).initCache();
        ((TownRepository)((Object)this.townRepository.get())).initCache();
        ((TownPlotRepository)((Object)this.townPlotRepository.get())).initCache();
        ((NationRepository)((Object)this.nationRepository.get())).initCache();
        ((NationPlotRepository)((Object)this.nationPlotRepository.get())).initCache();
    }

    public void flushCache() {
        ((ResidentRepository)((Object)this.residentRepository.get())).flushCache();
        ((TownPlotRepository)((Object)this.townPlotRepository.get())).flushCache();
        ((TownRepository)((Object)this.townRepository.get())).flushCache();
        ((NationRepository)((Object)this.nationRepository.get())).flushCache();
        ((NationPlotRepository)((Object)this.nationPlotRepository.get())).flushCache();
    }

    public Cache<Resident, UUID> getResidentCache() {
        return this.residentCache;
    }

    public TownPlotCache getTownPlotCache() {
        return this.townPlotCache;
    }

    public Cache<Town, Long> getTownCache() {
        return this.townCache;
    }

    public Cache<Nation, Long> getNationCache() {
        return this.nationCache;
    }

    public Cache<NationPlot, Long> getNationPlotCache() {
        return this.nationPlotCache;
    }
}

