/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.service;

import com.atherys.core.AtherysCore;
import com.atherys.towns.AtherysTowns;
import com.atherys.towns.TownsConfig;
import com.atherys.towns.api.event.NationEvent;
import com.atherys.towns.api.event.TownEvent;
import com.atherys.towns.model.entity.Nation;
import com.atherys.towns.model.entity.NationPlot;
import com.atherys.towns.model.entity.Resident;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.persistence.NationPlotRepository;
import com.atherys.towns.persistence.NationRepository;
import com.atherys.towns.persistence.ResidentRepository;
import com.atherys.towns.persistence.TownRepository;
import com.atherys.towns.service.ResidentService;
import com.atherys.towns.service.RoleService;
import com.atherys.towns.service.TownService;
import com.atherys.towns.service.TownsPermissionService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;

@Singleton
public class NationService {
    public static final Text DEFAULT_NATION_DESCRIPTION = Text.of((String)"No description available.");
    public static final TextColor DEFAULT_NATION_COLOR = TextColors.RESET;
    @Inject
    private TownService townService;
    @Inject
    private TownsPermissionService townsPermissionService;
    @Inject
    private ResidentService residentService;
    @Inject
    private RoleService roleService;
    @Inject
    private ResidentRepository residentRepository;
    @Inject
    private TownRepository townRepository;
    @Inject
    private NationRepository nationRepository;
    @Inject
    private NationPlotRepository nationPlotRepository;
    @Inject
    private TownsConfig config;

    public Optional<Nation> getNationFromName(String nationName) {
        return this.nationRepository.findByName(nationName);
    }

    public Nation createNation(String name, Town capital) {
        Nation nation = new Nation();
        nation.setName(name);
        nation.setDescription(DEFAULT_NATION_DESCRIPTION);
        nation.setColor(DEFAULT_NATION_COLOR);
        this.nationRepository.saveOne(nation);
        this.townService.setTownNation(capital, nation);
        nation.addTown(capital);
        nation.setCapital(capital);
        nation.setLeader(capital.getLeader());
        this.residentService.getUserFromResident(capital.getLeader()).ifPresent(user -> {
            this.roleService.addNationRole((Subject)user, nation, this.config.NATION.LEADER_ROLE);
            this.roleService.addNationRole((Subject)user, nation, this.config.NATION.DEFAULT_ROLE);
        });
        nation.setBank(UUID.randomUUID());
        if (AtherysTowns.economyIsEnabled()) {
            ((EconomyService)AtherysCore.getEconomyService().get()).getOrCreateAccount(nation.getBank());
        }
        this.nationRepository.saveOne(nation);
        Sponge.getEventManager().post((Event)new NationEvent.Created(nation));
        return nation;
    }

    public void disbandNation(Nation nation) {
        for (Town town : nation.getTowns()) {
            this.removeTown(nation, town);
        }
        this.nationRepository.deleteOne(nation);
        Sponge.getEventManager().post((Event)new NationEvent.Removed(nation));
    }

    public int getNationPopulation(Nation nation) {
        return nation.getTowns().stream().mapToInt(town -> town.getResidents().size()).sum();
    }

    public void setNationName(Nation nation, String name) {
        String oldName = nation.getName();
        nation.setName(name);
        this.nationRepository.saveOne(nation);
        Sponge.getEventManager().post((Event)new NationEvent.Renamed(nation, oldName, name));
    }

    public void setColor(Nation nation, TextColor color) {
        nation.setColor(color);
        this.nationRepository.saveOne(nation);
    }

    public void setNationDescription(Nation nation, Text description) {
        nation.setDescription(description);
        this.nationRepository.saveOne(nation);
    }

    public void addTown(Nation nation, Town town) {
        town.setNation(nation);
        nation.addTown(town);
        Sponge.getEventManager().post((Event)new TownEvent.JoinedNation(town, nation));
        this.townRepository.saveOne(town);
        this.nationRepository.saveOne(nation);
    }

    public void removeTown(Nation nation, Town town) {
        for (Resident resident : town.getResidents()) {
            this.residentService.getUserFromResident(resident).ifPresent(user -> this.townsPermissionService.clearPermissions((User)user, nation));
        }
        town.setNation(null);
        nation.removeTown(town);
        Sponge.getEventManager().post((Event)new TownEvent.LeftNation(town, nation));
        this.townRepository.saveOne(town);
        this.nationRepository.saveOne(nation);
    }

    public void setCapital(Nation nation, Town town) {
        nation.setCapital(town);
        this.nationRepository.saveOne(nation);
    }

    public void setTax(Nation nation, double tax) {
        nation.setTax(tax);
        this.nationRepository.saveOne(nation);
    }

    public void addNationAlly(Nation nation, Nation ally) {
        nation.removeEnemy(ally);
        nation.addAlly(ally);
        this.nationRepository.saveOne(nation);
    }

    public void addNationNeutral(Nation nation, Nation neutral) {
        nation.removeAlly(neutral);
        nation.removeEnemy(neutral);
        this.nationRepository.saveOne(nation);
    }

    public void addNationEnemy(Nation nation, Nation enemy) {
        nation.removeAlly(enemy);
        nation.addEnemy(enemy);
        this.nationRepository.saveOne(nation);
    }

    public void claimPlotForNation(NationPlot plot, Nation nation) {
        nation.addPlot(plot);
        plot.setNation(nation);
        this.nationPlotRepository.saveOne(plot);
        this.nationRepository.saveOne(nation);
    }

    public void removeNationPlot(NationPlot plot) {
        Nation nation = plot.getNation();
        nation.removePlot(plot);
        this.nationRepository.saveOne(nation);
        this.nationPlotRepository.deleteOne(plot);
    }

    public Collection<Nation> getAllNations() {
        return this.nationRepository.getAll();
    }
}

