/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.service;

import com.atherys.towns.model.Poll;
import com.atherys.towns.model.Vote;
import com.atherys.towns.model.entity.Nation;
import com.atherys.towns.model.entity.TownPlot;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;

@Singleton
public class PollService {
    private final HashMap<UUID, Poll> pollCache = new HashMap();

    @Inject
    PollService() {
    }

    public Poll getPollById(UUID id) {
        return this.pollCache.get(id);
    }

    public UUID createPoll(UUID pollCreator, String pollName, Set<UUID> voters, TownPlot homePlot, Nation nation) {
        UUID pollUUID = UUID.randomUUID();
        while (this.pollCache.containsKey(pollUUID)) {
            pollUUID = UUID.randomUUID();
        }
        Poll poll = new Poll();
        poll.setId(pollUUID);
        poll.setHomePlot(homePlot);
        poll.setVoters(voters);
        poll.setCreator(pollCreator);
        poll.setPollName(pollName);
        poll.setNation(nation);
        this.pollCache.put(pollUUID, poll);
        return pollUUID;
    }

    public void deletePoll(UUID id) {
        this.pollCache.remove(id);
    }

    public Set<Vote> getPollVotes(UUID id) {
        return this.pollCache.get(id).getVotes();
    }

    public void addVoteToPoll(Vote vote, UUID id) {
        this.pollCache.get(id).addVote(vote);
    }
}

