/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.service;

import com.atherys.core.economy.Economy;
import com.atherys.towns.model.entity.Nation;
import com.atherys.towns.model.entity.Resident;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.persistence.ResidentRepository;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.user.UserStorageService;

@Singleton
public class ResidentService {
    @Inject
    private ResidentRepository residentRepository;
    @Inject
    private UserStorageService userStorageService;

    ResidentService() {
    }

    protected Resident getOrCreate(UUID playerUuid, String playerName) {
        Optional resident = this.residentRepository.findById(playerUuid);
        if (resident.isPresent()) {
            Resident res = (Resident)resident.get();
            res.setLastLogin(LocalDateTime.now());
            return res;
        }
        Resident newResident = new Resident();
        newResident.setId(playerUuid);
        newResident.setName(playerName);
        newResident.setRegisteredOn(LocalDateTime.now());
        newResident.setLastTownSpawn(LocalDateTime.now().minus(1L, ChronoUnit.YEARS));
        this.residentRepository.saveOne(newResident);
        return newResident;
    }

    public Resident getOrCreate(User src) {
        return this.getOrCreate(src.getUniqueId(), src.getName());
    }

    public Optional<User> getUserFromResident(Resident resident) {
        return this.userStorageService.get(resident.getUniqueId());
    }

    public Optional<Player> getPlayerFromResident(Resident resident) {
        for (Player onlinePlayer : Sponge.getServer().getOnlinePlayers()) {
            if (!onlinePlayer.getUniqueId().equals(resident.getId())) continue;
            return Optional.of(onlinePlayer);
        }
        Optional<User> user = this.getUserFromResident(resident);
        return user.flatMap(User::getPlayer);
    }

    public void addResidentFriend(Resident resident, Resident friend) {
        resident.addFriend(friend);
        this.residentRepository.saveOne(resident);
    }

    public void removeResidentFriend(Resident resident, Resident friend) {
        resident.removeFriend(friend);
        this.residentRepository.saveOne(resident);
    }

    public void setLastTownSpawn(Resident resident, LocalDateTime time) {
        resident.setLastTownSpawn(time);
        this.residentRepository.saveOne(resident);
    }

    public void setLastLogin(Resident resident, LocalDateTime time) {
        resident.setLastLogin(time);
        this.residentRepository.saveOne(resident);
    }

    public Optional<UniqueAccount> getResidentBank(Resident resident) {
        return Economy.getAccount((UUID)resident.getId());
    }

    public void addCurrency(Resident resident, BigDecimal amount, Currency currency, Cause cause) {
        Economy.addCurrency((UUID)resident.getId(), (Currency)currency, (BigDecimal)amount, (Cause)cause);
    }

    public void removeCurrency(Resident resident, BigDecimal amount, Currency currency, Cause cause) {
        Economy.removeCurrency((UUID)resident.getId(), (Currency)currency, (BigDecimal)amount, (Cause)cause);
    }

    public void transferCurrency(Resident source, Town destination, Currency currency, BigDecimal amount, Cause cause) {
        Economy.transferCurrency((UUID)source.getId(), (UUID)destination.getBank(), (Currency)currency, (BigDecimal)amount, (Cause)cause);
    }

    public void transferCurrency(Resident source, Nation destination, Currency currency, BigDecimal amount, Cause cause) {
        Economy.transferCurrency((UUID)source.getId(), (UUID)destination.getBank(), (Currency)currency, (BigDecimal)amount, (Cause)cause);
    }

    public void transferCurrency(Town source, Resident destination, Currency currency, BigDecimal amount, Cause cause) {
        Economy.transferCurrency((UUID)source.getBank(), (UUID)destination.getId(), (Currency)currency, (BigDecimal)amount, (Cause)cause);
    }

    public void transferCurrency(Nation source, Resident destination, Currency currency, BigDecimal amount, Cause cause) {
        Economy.transferCurrency((UUID)source.getBank(), (UUID)destination.getId(), (Currency)currency, (BigDecimal)amount, (Cause)cause);
    }

    public boolean isResidentTownLeader(Resident resident, Town town) {
        return town.getLeader().getId().equals(resident.getId());
    }

    public void grantTownRole(Resident resident, String role) {
        resident.getTownRoleIds().add(role);
        this.residentRepository.saveOne(resident);
    }

    public void grantNationRole(Resident resident, String role) {
        resident.getNationRoleIds().add(role);
        this.residentRepository.saveOne(resident);
    }

    public void removeTownRole(Resident resident, String role) {
        resident.getTownRoleIds().remove(role);
        this.residentRepository.saveOne(resident);
    }

    public void removeNationRole(Resident resident, String role) {
        resident.getNationRoleIds().remove(role);
        this.residentRepository.saveOne(resident);
    }
}

