/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.service;

import com.atherys.towns.AtherysTowns;
import com.atherys.towns.TownsConfig;
import com.atherys.towns.api.permission.Permission;
import com.atherys.towns.api.permission.world.WorldPermission;
import com.atherys.towns.model.entity.Nation;
import com.atherys.towns.model.entity.Resident;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.service.ResidentService;
import com.atherys.towns.service.TownsPermissionService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.Set;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.util.Tristate;

@Singleton
public class RoleService {
    private static final String TOWN_PREFIX = "role.town.";
    private static final String NATION_PREFIX = "role.nation.";
    @Inject
    TownsPermissionService townsPermissionService;
    @Inject
    ResidentService residentService;
    @Inject
    TownsConfig config;
    PermissionService permissionService;

    public void init() {
        if (this.config.NATION.GENERATE_ROLES) {
            this.config.NATION.ROLES.forEach((id, roleConfig) -> this.createRole(NATION_PREFIX + id, roleConfig.getNationPermissions(), Collections.emptySet()));
        }
        if (this.config.TOWN.GENERATE_ROLES) {
            this.config.TOWN.ROLES.forEach((id, roleConfig) -> this.createRole(TOWN_PREFIX + id, roleConfig.getTownPermissions(), roleConfig.getWorldPermissions()));
        }
    }

    public void createRole(String id, Set<? extends Permission> permissions, Set<WorldPermission> worldPermissions) {
        SubjectReference ref = this.getSpongePermissionService().getGroupSubjects().newSubjectReference(id);
        ref.resolve().thenAccept(subject -> {
            SubjectData subjectData = subject.getSubjectData();
            subjectData.clearPermissions();
            for (Permission permission : permissions) {
                subjectData.setPermission(SubjectData.GLOBAL_CONTEXT, permission.getId(), Tristate.TRUE);
                AtherysTowns.getInstance().getLogger().info(permission.getId());
            }
            for (Permission permission : worldPermissions) {
                subjectData.setPermission(SubjectData.GLOBAL_CONTEXT, permission.getId(), Tristate.TRUE);
            }
        });
    }

    public void addNationRole(Subject subject, Nation nation, String role) {
        Subject roleSubject = (Subject)this.getSpongePermissionService().getGroupSubjects().getSubject(NATION_PREFIX + role).get();
        Set<Context> nationContext = this.townsPermissionService.getContextForNation(nation);
        subject.getSubjectData().addParent(nationContext, roleSubject.asSubjectReference());
    }

    public void removeNationRole(Subject subject, Nation nation, String role) {
        Subject roleSubject = (Subject)this.getSpongePermissionService().getGroupSubjects().getSubject(NATION_PREFIX + role).get();
        Set<Context> nationContext = this.townsPermissionService.getContextForNation(nation);
        subject.getSubjectData().removeParent(nationContext, roleSubject.asSubjectReference());
    }

    public void addTownRole(User user, Town town, String role) {
        Subject roleSubject = (Subject)this.getSpongePermissionService().getGroupSubjects().getSubject(TOWN_PREFIX + role).get();
        Set<Context> townContexts = this.townsPermissionService.getContextsForTown(town);
        user.getSubjectData().addParent(townContexts, roleSubject.asSubjectReference());
    }

    public void removeTownRole(User user, Town town, String role) {
        Subject roleSubject = (Subject)this.getSpongePermissionService().getGroupSubjects().getSubject(TOWN_PREFIX + role).get();
        Set<Context> townContexts = this.townsPermissionService.getContextsForTown(town);
        user.getSubjectData().removeParent(townContexts, roleSubject.asSubjectReference());
    }

    public void validateRoles(User user, Resident resident) {
        for (String role : resident.getTownRoleIds()) {
            if (this.config.TOWN.ROLES.containsKey(role)) continue;
            this.residentService.removeTownRole(resident, role);
        }
        for (String role : resident.getNationRoleIds()) {
            if (this.config.NATION.ROLES.containsKey(role)) continue;
            this.residentService.removeNationRole(resident, role);
        }
    }

    private PermissionService getSpongePermissionService() {
        if (this.permissionService == null) {
            this.permissionService = (PermissionService)Sponge.getServiceManager().provide(PermissionService.class).get();
        }
        return this.permissionService;
    }
}

