/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.service;

import com.atherys.core.economy.Economy;
import com.atherys.towns.TownsConfig;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.persistence.TownRepository;
import com.atherys.towns.service.TownService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.transaction.TransferResult;

@Singleton
public class TaxService {
    @Inject
    private TownsConfig config;
    @Inject
    private TownService townService;
    @Inject
    private TownRepository townRepository;

    public double getTaxAmount(Town town) {
        double pvpMultiplier = town.isPvpEnabled() ? 1.0 : this.config.TAXES.PVP_TAX_MODIFIER;
        double nationMultiplier = town.getNation() == null ? 1.0 : town.getNation().getTax();
        return nationMultiplier * pvpMultiplier * (this.calcBaseTax(town) + this.calcResidentTax(town) + this.calcAreaTax(town)) + town.getDebt();
    }

    public double calcResidentTax(Town town) {
        long numberOfActiveResidents = town.getResidents().stream().filter(resident -> Duration.between(resident.getLastLogin(), LocalDateTime.now()).compareTo(this.config.TAXES.INACTIVE_DURATION) < 0).count();
        return (long)this.config.TAXES.PER_RESIDENT_TAX * numberOfActiveResidents;
    }

    public double calcAreaTax(Town town) {
        int townArea = this.townService.getTownSize(town);
        return this.config.TAXES.PER_BLOCK_AREA_TAX * (double)townArea + this.calcOversizeAreaTax(town, townArea);
    }

    public double calcOversizeAreaTax(Town town, int townArea) {
        int oversizeArea = townArea > town.getMaxSize() ? townArea - town.getMaxSize() : 0;
        return this.config.TAXES.OVERSIZE_AREA_TAX_MODIFIER * this.config.TAXES.PER_BLOCK_AREA_TAX * (double)oversizeArea;
    }

    public double calcBaseTax(Town town) {
        return this.config.TAXES.BASE_TAX;
    }

    public void setTaxesPaid(Town town, boolean paid) {
        if (!paid) {
            this.townService.addFailedTaxOccurrence(town);
            this.townService.setTownPvp(town, true);
        } else {
            this.townService.setTownTaxFailCount(town, 0);
            this.townService.setTownDebt(town, 0.0);
        }
    }

    public Optional<TransferResult> payTaxes(Town town, double amount) {
        Cause cause = Sponge.getCauseStackManager().getCurrentCause();
        return Economy.transferCurrency((String)town.getBank().toString(), (String)town.getNation().getBank().toString(), (Currency)this.config.DEFAULT_CURRENCY, (BigDecimal)BigDecimal.valueOf(amount), (Cause)cause);
    }

    private boolean isTaxTime(Town town) {
        return Duration.between(town.getLastTaxDate(), LocalDateTime.now()).compareTo(this.config.TAXES.TAX_COLLECTION_DURATION) > 0;
    }

    public boolean isTaxable(Town town) {
        return town.isTaxable() && town.getNation() != null && !town.getNation().getCapital().equals(town);
    }

    public Set<Town> getTaxableTowns() {
        return this.townRepository.getAll().stream().filter(this::isTaxable).filter(this::isTaxTime).filter(town -> !town.getNation().getCapital().equals(town)).collect(Collectors.toSet());
    }
}

