/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.service;

import com.atherys.towns.AtherysTowns;
import com.atherys.towns.TownsConfig;
import com.atherys.towns.facade.TownFacade;
import com.atherys.towns.facade.TownRaidFacade;
import com.atherys.towns.facade.TownsMessagingFacade;
import com.atherys.towns.model.RaidPoint;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.service.TownService;
import com.atherys.towns.util.MathUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.spongepowered.api.boss.BossBarColors;
import org.spongepowered.api.boss.BossBarOverlays;
import org.spongepowered.api.boss.ServerBossBar;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Singleton
public class TownRaidService {
    @Inject
    TownsConfig config;
    @Inject
    TownService townService;
    @Inject
    TownRaidFacade townRaidFacade;
    @Inject
    TownFacade townFacade;
    @Inject
    TownsMessagingFacade townsMsg;
    Map<UUID, RaidPoint> activeRaids = new ConcurrentHashMap<UUID, RaidPoint>();

    private void removeEntityFromWorld(World world, UUID entityUUID) {
        Optional entity = world.getEntity(entityUUID);
        entity.ifPresent(Entity::remove);
    }

    public void removeRaidPoint(UUID id) {
        RaidPoint point = this.activeRaids.get(id);
        World world = (World)point.getPointTransform().getExtent();
        ServerBossBar bossBar = point.getRaidBossBar();
        bossBar.removePlayers(bossBar.getPlayers());
        this.removeEntityFromWorld(world, id);
        point.getParticleUUIDs().forEach(uuid -> this.removeEntityFromWorld(world, (UUID)uuid));
        this.activeRaids.remove(id);
    }

    public RaidPoint getRaidPoint(UUID id) {
        return this.activeRaids.get(id);
    }

    public boolean isIdRaidEntity(UUID entityId) {
        return this.activeRaids.containsKey(entityId);
    }

    public Optional<RaidPoint> getTownRaidPoint(Town town) {
        return this.activeRaids.values().stream().filter(point -> point.getRaidingTown().equals(town)).findFirst();
    }

    public void createRaidPointEntry(Transform<World> transform, Town town, Town targetTown, UUID entityId, Set<UUID> particleEffects) {
        ServerBossBar raidBar = ServerBossBar.builder().name(Text.of((Object[])new Object[]{"Hired Mage | Time Left: ", this.townRaidFacade.formatDurationLeft(LocalDateTime.now(), this.config.RAID.RAID_DURATION)})).overlay(BossBarOverlays.PROGRESS).color(BossBarColors.RED).percent(1.0f).build();
        RaidPoint point = new RaidPoint(LocalDateTime.now(), transform, entityId, town, targetTown, particleEffects, raidBar);
        this.townService.setTownLastRaidCreationDate(town, LocalDateTime.now());
        this.activeRaids.put(entityId, point);
    }

    public boolean isTownRaidActive(Town town) {
        return this.getTownRaidPoint(town).isPresent();
    }

    public boolean isLocationTaken(Location<World> location) {
        double raidDistance = Math.pow(this.config.RAID.RAID_DISTANCE_BETWEEN_POINTS, 2.0);
        return this.activeRaids.values().stream().anyMatch(point -> MathUtils.getDistanceBetweenPointsSquared(location.getPosition(), point.getPointTransform().getPosition()) < raidDistance);
    }

    public boolean hasCooldownPeriodPassed(Town town) {
        Optional<LocalDateTime> raidCreationDate = town.getLastRaidCreationDate();
        return raidCreationDate.map(dateTime -> Duration.between(dateTime, LocalDateTime.now()).compareTo(this.config.RAID.RAID_COOLDOWN) >= 0).orElse(true);
    }

    public boolean hasDurationPassed(Town town) {
        Optional<LocalDateTime> raidCreationDate = town.getLastRaidCreationDate();
        return raidCreationDate.map(dateTime -> Duration.between(dateTime, LocalDateTime.now()).compareTo(this.config.RAID.RAID_DURATION) >= 0).orElse(true);
    }

    public void initRaidTimer() {
        Task.Builder taxTimer = Task.builder();
        taxTimer.interval(2L, TimeUnit.SECONDS).execute(this.RaidTimerTask()).submit((Object)AtherysTowns.getInstance());
    }

    public double getRaidHealth(World world, RaidPoint point) {
        Optional entity = world.getEntity(point.getRaidPointUUID());
        if (entity.isPresent()) {
            return entity.map(value -> Math.round(value.get(Keys.HEALTH).orElse(0.0))).get().longValue();
        }
        return 0.0;
    }

    private void updateBossBarPlayers(UUID pointId) {
        RaidPoint point = this.activeRaids.get(pointId);
        Location location = point.getPointTransform().getLocation();
        Set playersInRadius = ((World)location.getExtent()).getNearbyEntities(location.getPosition(), (double)this.config.RAID.RAID_BOSS_BAR_DISTANCE).stream().filter(entity -> entity instanceof Player).map(entity -> (Player)entity).collect(Collectors.toSet());
        Collection bossBarPlayers = point.getRaidBossBar().getPlayers();
        ServerBossBar bossBar = point.getRaidBossBar();
        Set removePlayers = bossBarPlayers.stream().filter(player -> !playersInRadius.contains(player)).collect(Collectors.toSet());
        bossBar.removePlayers(removePlayers);
        Set addPlayers = playersInRadius.stream().filter(player -> !bossBarPlayers.contains(player)).collect(Collectors.toSet());
        bossBar.addPlayers(addPlayers);
    }

    private void updateBossBar(UUID pointId) {
        RaidPoint point = this.activeRaids.get(pointId);
        double raidHealth = this.getRaidHealth((World)point.getPointTransform().getExtent(), point);
        double raidPercentage = raidHealth / this.config.RAID.RAID_HEALTH * 100.0;
        point.getRaidBossBar().setName(Text.of((Object[])new Object[]{"Hired Mage | Time Left: ", this.townRaidFacade.formatDurationLeft(point.getCreationTime(), this.config.RAID.RAID_DURATION)}));
        point.getRaidBossBar().setPercent((float)(raidPercentage / 100.0));
        this.updateBossBarPlayers(pointId);
    }

    private Runnable RaidTimerTask() {
        return () -> {
            HashSet pointsToRemove = new HashSet();
            this.activeRaids.forEach((uuid, point) -> {
                this.updateBossBar((UUID)uuid);
                if (this.hasDurationPassed(point.getRaidingTown())) {
                    pointsToRemove.add(uuid);
                    this.townFacade.getOnlineTownMembers(point.getRaidingTown()).forEach(player -> this.townsMsg.info((MessageReceiver)player, new Object[]{Text.of((String)"Your raid point has expired!")}));
                }
            });
            pointsToRemove.forEach(this::removeRaidPoint);
        };
    }
}

