/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.service;

import com.atherys.core.AtherysCore;
import com.atherys.towns.AtherysTowns;
import com.atherys.towns.TownsConfig;
import com.atherys.towns.api.event.ResidentEvent;
import com.atherys.towns.api.event.TownEvent;
import com.atherys.towns.model.entity.Nation;
import com.atherys.towns.model.entity.Resident;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.model.entity.TownPlot;
import com.atherys.towns.persistence.ResidentRepository;
import com.atherys.towns.persistence.TownPlotRepository;
import com.atherys.towns.persistence.TownRepository;
import com.atherys.towns.service.NationService;
import com.atherys.towns.service.PlotService;
import com.atherys.towns.service.ResidentService;
import com.atherys.towns.service.RoleService;
import com.atherys.towns.service.TownsPermissionService;
import com.atherys.towns.util.MathUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.World;

@Singleton
public class TownService {
    public static final Text DEFAULT_TOWN_DESCRIPTION = Text.of((String)"Town description.");
    public static final Text DEFAULT_TOWN_MOTD = Text.of((String)"Message of the day.");
    public static final TextColor DEFAULT_TOWN_COLOR = TextColors.RESET;
    public static final boolean DEFAULT_TOWN_PVP = false;
    public static final boolean DEFAULT_TOWN_FREELY_JOINABLE = false;
    private final TownsConfig config;
    private final PlotService plotService;
    private final NationService nationService;
    private final TownRepository townRepository;
    private TownPlotRepository townPlotRepository;
    private final ResidentRepository residentRepository;
    private final ResidentService residentService;
    private final TownsPermissionService townsPermissionService;
    private final RoleService roleService;

    @Inject
    TownService(TownsConfig config, PlotService plotService, TownRepository townRepository, TownPlotRepository townPlotRepository, NationService nationService, ResidentRepository residentRepository, ResidentService residentService, TownsPermissionService townsPermissionService, RoleService roleService) {
        this.config = config;
        this.plotService = plotService;
        this.townRepository = townRepository;
        this.townPlotRepository = townPlotRepository;
        this.residentRepository = residentRepository;
        this.nationService = nationService;
        this.residentService = residentService;
        this.townsPermissionService = townsPermissionService;
        this.roleService = roleService;
    }

    public Town createTown(Player leader, TownPlot homePlot, String name, @Nullable Nation nation) {
        Town town = new Town();
        Resident resLeader = this.residentService.getOrCreate((User)leader);
        if (resLeader.getTown() != null) {
            this.removeResidentFromTown((User)leader, resLeader, resLeader.getTown());
        }
        town.setLeader(resLeader);
        town.setName(name);
        town.setDescription(DEFAULT_TOWN_DESCRIPTION);
        town.setMotd(DEFAULT_TOWN_MOTD);
        town.setColor(DEFAULT_TOWN_COLOR);
        town.setMaxSize(this.config.TOWN.DEFAULT_TOWN_MAX_SIZE);
        town.setPvpEnabled(false);
        town.setFreelyJoinable(false);
        town.setWorld(leader.getWorld().getUniqueId());
        town.setLastTaxDate(LocalDateTime.now());
        town.setTaxFailedCount(0);
        town.setDebt(0.0);
        town.setBank(UUID.randomUUID());
        town.setTaxable(true);
        if (nation != null) {
            this.nationService.addTown(nation, town);
        }
        if (AtherysTowns.economyIsEnabled()) {
            ((EconomyService)AtherysCore.getEconomyService().get()).getOrCreateAccount(town.getBank());
        }
        town.setSpawn((Transform<World>)leader.getTransform());
        homePlot.setName((Text)Text.of((String)"HomePlot"));
        homePlot.setTown(town);
        town.addPlot(homePlot);
        resLeader.setTown(town);
        town.addResident(resLeader);
        this.townRepository.saveOne(town);
        this.townPlotRepository.saveOne(homePlot);
        this.residentRepository.saveOne(resLeader);
        this.roleService.addTownRole((User)leader, town, this.config.TOWN.TOWN_LEADER_ROLE);
        this.roleService.addTownRole((User)leader, town, this.config.TOWN.TOWN_DEFAULT_ROLE);
        Sponge.getEventManager().post((Event)new TownEvent.Created(town));
        return town;
    }

    public Optional<Town> getTownFromName(String townName) {
        return this.townRepository.findByName(townName);
    }

    public void setTownLeader(Town town, Resident resident, User user) {
        town.setLeader(resident);
        this.townRepository.saveOne(town);
        this.roleService.addTownRole(user, town, this.config.TOWN.TOWN_LEADER_ROLE);
    }

    public void setTownName(Town town, String name) {
        String oldName = town.getName();
        town.setName(name);
        this.townRepository.saveOne(town);
        Sponge.getEventManager().post((Event)new TownEvent.Renamed(town, oldName, name));
    }

    public void setTownMotd(Town town, Text motd) {
        town.setMotd(motd);
        this.townRepository.saveOne(town);
    }

    public void setTownColor(Town town, TextColor textColor) {
        town.setColor(textColor);
        this.townRepository.saveOne(town);
    }

    public void setTownDescription(Town town, Text desc) {
        town.setDescription(desc);
        this.townRepository.saveOne(town);
    }

    public void setTownPvp(Town town, boolean pvp) {
        town.setPvpEnabled(pvp);
        this.townRepository.saveOne(town);
    }

    public void setTownTaxFailCount(Town town, int count) {
        town.setTaxFailedCount(count);
        this.townRepository.saveOne(town);
    }

    public void setTownDebt(Town town, double debt) {
        town.setDebt(debt);
        this.townRepository.saveOne(town);
    }

    public void addFailedTaxOccurrence(Town town) {
        town.setTaxFailedCount(town.getTaxFailedCount() + 1);
        this.townRepository.saveOne(town);
    }

    public void addTownDebt(Town town, double debt) {
        town.setDebt(town.getDebt() + debt);
        this.townRepository.saveOne(town);
    }

    public void setTownNation(Town town, Nation nation) {
        Set ids = town.getResidents().stream().map(resident -> resident.getId().toString()).collect(Collectors.toSet());
        AtherysTowns.getInstance().getLogger().info(ids.toString());
        Set<Context> nationContext = town.getNation() == null ? null : this.townsPermissionService.getContextForNation(town.getNation());
        ((PermissionService)Sponge.getServiceManager().provideUnchecked(PermissionService.class)).getUserSubjects().applyToAll(subject -> {
            if (town.getNation() != null) {
                this.townsPermissionService.clearPermissions((Subject)subject, nationContext);
            }
            this.roleService.addNationRole((Subject)subject, nation, this.config.NATION.DEFAULT_ROLE);
        }, ids);
        town.setNation(nation);
        this.townRepository.saveOne(town);
    }

    public void setTownJoinable(Town town, boolean joinable) {
        town.setFreelyJoinable(joinable);
        this.townRepository.saveOne(town);
    }

    public void setTownSpawn(Town town, Transform<World> spawn) {
        town.setSpawn(spawn);
        this.townRepository.saveOne(town);
    }

    public void setTownLastRaidCreationDate(Town town, LocalDateTime dateTime) {
        town.setLastRaidCreationDate(dateTime);
        this.townRepository.saveOne(town);
    }

    public void removePlotFromTown(Town town, TownPlot plot) {
        town.removePlot(plot);
        this.removePlotFromGraph(town, plot);
        this.townRepository.saveOne(town);
        this.townPlotRepository.deleteOne(plot);
    }

    public void claimPlotForTown(TownPlot plot, Town town) {
        plot.setName(Text.of((Object[])new Object[]{"Plot #", town.getPlots().size()}));
        town.addPlot(plot);
        plot.setTown(town);
        this.townPlotRepository.saveOne(plot);
        this.townRepository.saveOne(town);
        this.addPlotToGraph(town, plot);
    }

    public void generatePlotGraph(Town town) {
        HashMap<TownPlot, Set<TownPlot>> adjList = new HashMap<TownPlot, Set<TownPlot>>();
        for (TownPlot plota : town.getPlots()) {
            for (TownPlot plotb : town.getPlots()) {
                if (plota == plotb) continue;
                Set plotaNeighbours = adjList.computeIfAbsent(plota, k -> new HashSet());
                Set plotbNeighbours = adjList.computeIfAbsent(plotb, k -> new HashSet());
                if (plotaNeighbours.contains(plotb) || !MathUtils.borders(plota, plotb)) continue;
                plotaNeighbours.add(plotb);
                plotbNeighbours.add(plota);
            }
        }
        town.setPlotGraphAdjList(adjList);
    }

    public void addPlotToGraph(Town town, TownPlot newPlot) {
        Map<TownPlot, Set<TownPlot>> adjList = town.getPlotGraphAdjList();
        if (adjList == null) {
            return;
        }
        for (TownPlot existingPlot : town.getPlots()) {
            if (newPlot == existingPlot) continue;
            Set newPlotNeighbours = adjList.computeIfAbsent(newPlot, k -> new HashSet());
            Set existingPlotNeighbours = adjList.computeIfAbsent(existingPlot, k -> new HashSet());
            if (!MathUtils.borders(newPlot, existingPlot)) continue;
            newPlotNeighbours.add(existingPlot);
            existingPlotNeighbours.add(newPlot);
        }
    }

    public void removePlotFromGraph(Town town, TownPlot removedPlot) {
        Map<TownPlot, Set<TownPlot>> adjList = town.getPlotGraphAdjList();
        if (adjList == null) {
            return;
        }
        for (TownPlot existingPlot : town.getPlots()) {
            Set existingPlotNeighbours = adjList.computeIfAbsent(existingPlot, k -> new HashSet());
            existingPlotNeighbours.remove(removedPlot);
        }
        adjList.remove(removedPlot);
    }

    public boolean checkPlotRemovalCreatesOrphans(Town town, TownPlot targetPlot) {
        HashMap<TownPlot, Boolean> visited = new HashMap<TownPlot, Boolean>();
        int rootChildren = 0;
        Map<TownPlot, Set<TownPlot>> adjList = town.getPlotGraphAdjList();
        if (adjList == null) {
            this.generatePlotGraph(town);
            adjList = town.getPlotGraphAdjList();
        }
        Stack<Tuple> stack = new Stack<Tuple>();
        visited.put(targetPlot, true);
        for (TownPlot child : adjList.get(targetPlot)) {
            stack.push(Tuple.of((Object)targetPlot, (Object)child));
        }
        while (!stack.empty()) {
            Tuple t = (Tuple)stack.pop();
            TownPlot parent = (TownPlot)t.getFirst();
            TownPlot plot = (TownPlot)t.getSecond();
            if (!visited.getOrDefault(plot, false).booleanValue()) {
                visited.put(plot, true);
                if (parent == targetPlot) {
                    ++rootChildren;
                }
                if (rootChildren >= 2) {
                    return true;
                }
            }
            for (TownPlot child : adjList.get(plot)) {
                if (visited.getOrDefault(child, false).booleanValue()) continue;
                stack.push(Tuple.of((Object)plot, (Object)child));
            }
        }
        return false;
    }

    public int getTownSize(Town town) {
        int size = 0;
        for (TownPlot plot : town.getPlots()) {
            size += MathUtils.getArea(plot);
        }
        return size;
    }

    public void increaseTownSize(Town town, int amount) {
        town.setMaxSize(town.getMaxSize() + amount);
        this.townRepository.saveOne(town);
    }

    public void decreaseTownSize(Town town, int amount) {
        town.setMaxSize(town.getMaxSize() - amount);
        this.townRepository.saveOne(town);
    }

    public void removeTown(Town town) {
        Set<Context> townContext = this.townsPermissionService.getContextsForTown(town);
        HashSet ids = new HashSet();
        town.getResidents().forEach(resident -> {
            resident.setTown(null);
            ids.add(resident.getId().toString());
            Sponge.getEventManager().post((Event)new ResidentEvent.LeftTown((Resident)resident, town));
        });
        ((PermissionService)Sponge.getServiceManager().provideUnchecked(PermissionService.class)).getUserSubjects().applyToAll(subject -> this.townsPermissionService.clearPermissions((Subject)subject, townContext), ids);
        if (town.getNation() != null) {
            this.nationService.removeTown(town.getNation(), town);
        }
        this.residentRepository.saveAll(town.getResidents());
        this.townPlotRepository.deleteAll(town.getPlots());
        this.townRepository.deleteOne(town);
        Sponge.getEventManager().post((Event)new TownEvent.Removed(town));
    }

    public void addResidentToTown(User user, Resident resident, Town town) {
        town.addResident(resident);
        resident.setTown(town);
        this.roleService.addTownRole(user, town, this.config.TOWN.TOWN_DEFAULT_ROLE);
        if (town.getNation() != null) {
            this.roleService.addNationRole((Subject)user, town.getNation(), this.config.NATION.DEFAULT_ROLE);
        }
        this.townsPermissionService.updateContexts(user, resident);
        this.townRepository.saveOne(town);
        this.residentRepository.saveOne(resident);
        Sponge.getEventManager().post((Event)new ResidentEvent.JoinedTown(resident, town));
    }

    public void removeResidentFromTown(User user, Resident resident, Town town) {
        town.removeResident(resident);
        resident.setTown(null);
        this.townsPermissionService.clearPermissions(user, town);
        this.townsPermissionService.updateContexts(user, resident);
        this.townRepository.saveOne(town);
        this.residentRepository.saveOne(resident);
        Sponge.getEventManager().post((Event)new ResidentEvent.LeftTown(resident, town));
    }

    public Collection<Town> fetchAllTowns() {
        return this.townRepository.getAll();
    }

    public void setTownTaxable(Town town, boolean taxable) {
        town.setTaxable(taxable);
    }
}

