/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.service;

import com.atherys.towns.api.permission.Permission;
import com.atherys.towns.api.permission.nation.NationPermission;
import com.atherys.towns.api.permission.town.TownPermission;
import com.atherys.towns.api.permission.world.WorldPermission;
import com.atherys.towns.model.entity.Nation;
import com.atherys.towns.model.entity.Resident;
import com.atherys.towns.model.entity.Town;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.Tristate;

@Singleton
public class TownsPermissionService {
    public static final String TOWN_CONTEXT_KEY = "atherystowns:town";
    public static final String TOWN_WORLD_CONTEXT_KEY = "atherystowns:world_town";
    public static final String NATION_CONTEXT_KEY = "atherystowns:nation";
    public static final String NATION_WORLD_CONTEXT_KEY = "atherystowns:world_nation";
    private Map<UUID, Context> playerTownContexts = new HashMap<UUID, Context>();
    private Map<UUID, Context> playerNationContexts = new HashMap<UUID, Context>();
    private Map<UUID, Context> playerWorldTownContexts = new HashMap<UUID, Context>();
    private Map<UUID, Context> playerWorldNationContexts = new HashMap<UUID, Context>();

    public void updateContexts(@Nonnull User player, @Nullable Resident resident) {
        if (resident != null && resident.getTown() != null) {
            Town town = resident.getTown();
            this.playerTownContexts.put(player.getUniqueId(), new Context(TOWN_CONTEXT_KEY, town.getId().toString()));
            Nation nation = town.getNation();
            if (nation != null) {
                this.playerNationContexts.put(player.getUniqueId(), new Context(NATION_CONTEXT_KEY, nation.getId().toString()));
            }
        } else {
            this.playerTownContexts.remove(player.getUniqueId());
            this.playerNationContexts.remove(player.getUniqueId());
        }
    }

    public Set<Context> getContextsForTown(Town town) {
        Context nationContext;
        Context townContext = new Context(TOWN_CONTEXT_KEY, town.getId().toString());
        Context context = nationContext = town.getNation() == null ? null : new Context(NATION_CONTEXT_KEY, town.getNation().getId().toString());
        if (nationContext != null) {
            return ImmutableSet.of((Object)townContext, (Object)nationContext);
        }
        return Collections.singleton(townContext);
    }

    public Set<Context> getContextForNation(Nation nation) {
        return Collections.singleton(new Context(NATION_CONTEXT_KEY, nation.getId().toString()));
    }

    public void updateWorldContexts(@Nonnull Player player, @Nullable Town town) {
        if (town != null) {
            this.playerWorldTownContexts.put(player.getUniqueId(), new Context(TOWN_WORLD_CONTEXT_KEY, town.getId().toString()));
            Nation nation = town.getNation();
            if (nation != null) {
                this.playerWorldNationContexts.put(player.getUniqueId(), new Context(NATION_WORLD_CONTEXT_KEY, nation.getId().toString()));
            }
        } else {
            this.playerWorldTownContexts.remove(player.getUniqueId());
            this.playerWorldNationContexts.remove(player.getUniqueId());
        }
    }

    public void accumulateContexts(Subject calculable, Set<Context> accumulator) {
        Optional commandSource = calculable.getCommandSource();
        if (commandSource.isPresent() && commandSource.get() instanceof Player) {
            Player player = (Player)commandSource.get();
            if (this.playerTownContexts.containsKey(player.getUniqueId())) {
                accumulator.add(this.playerTownContexts.get(player.getUniqueId()));
            }
            if (this.playerNationContexts.containsKey(player.getUniqueId())) {
                accumulator.add(this.playerNationContexts.get(player.getUniqueId()));
            }
            if (this.playerWorldTownContexts.containsKey(player.getUniqueId())) {
                accumulator.add(this.playerWorldTownContexts.get(player.getUniqueId()));
            }
            if (this.playerWorldNationContexts.containsKey(player.getUniqueId())) {
                accumulator.add(this.playerWorldNationContexts.get(player.getUniqueId()));
            }
        }
    }

    public boolean isPermitted(Player player, Permission permission) {
        return player.hasPermission(permission.getId());
    }

    public void setNationPermission(Player player, NationPermission permission, Tristate tristate) {
        if (this.playerNationContexts.containsKey(player.getUniqueId())) {
            Set<Context> nationContext = Collections.singleton(this.playerNationContexts.get(player.getUniqueId()));
            player.getSubjectData().setPermission(nationContext, permission.getId(), tristate);
        }
    }

    public void setTownPermission(Player player, TownPermission permission, Tristate tristate) {
        if (this.playerTownContexts.containsKey(player.getUniqueId())) {
            Set<Context> townContext = Collections.singleton(this.playerTownContexts.get(player.getUniqueId()));
            player.getSubjectData().setPermission(townContext, permission.getId(), tristate);
        }
    }

    public void setWorldPermission(Player player, WorldPermission permission, Tristate tristate) {
        HashSet<Context> contexts = new HashSet<Context>();
        if (this.playerWorldTownContexts.containsKey(player.getUniqueId())) {
            contexts.add(this.playerWorldTownContexts.get(player.getUniqueId()));
        }
        if (this.playerWorldNationContexts.containsKey(player.getUniqueId())) {
            contexts.add(this.playerWorldNationContexts.get(player.getUniqueId()));
        }
        player.getSubjectData().setPermission(contexts, permission.getId(), tristate);
    }

    public void removeTownRole() {
    }

    public void clearPermissions(User user, Town town) {
        this.clearPermissions((Subject)user, this.getContextsForTown(town));
    }

    public void clearPermissions(User user, Nation nation) {
        this.clearPermissions((Subject)user, this.getContextForNation(nation));
    }

    public void clearPermissions(Subject subject, Set<Context> contexts) {
        subject.getSubjectData().clearParents(contexts);
        subject.getSubjectData().clearPermissions(contexts);
    }
}

