/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.util;

import com.atherys.towns.util.BasicRectangle;
import com.atherys.towns.util.Rectangle;
import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class MathUtils {
    public static Vector2i vec3iToVec2i(Vector3i vector3i) {
        return Vector2i.from((int)vector3i.getX(), (int)vector3i.getZ());
    }

    public static void populateRectangleFromTwoCorners(Rectangle rect, Vector2d pA, Vector2d pB) {
        Vector2d pSW;
        Vector2d pNE;
        if (pA.getX() > pB.getX() && pA.getY() < pB.getY()) {
            pNE = pA;
            pSW = pB;
        } else if (pA.getX() < pB.getX() && pA.getY() > pB.getY()) {
            pNE = pB;
            pSW = pA;
        } else if (pA.getX() > pB.getX() && pA.getY() > pB.getY()) {
            pNE = Vector2d.from((double)pA.getX(), (double)pB.getY());
            pSW = Vector2d.from((double)pB.getX(), (double)pA.getY());
        } else if (pA.getX() < pB.getX() && pA.getY() < pB.getY()) {
            pNE = Vector2d.from((double)pB.getX(), (double)pA.getY());
            pSW = Vector2d.from((double)pA.getX(), (double)pB.getY());
        } else {
            throw new IllegalArgumentException("Could not resolve south-west and north-east plot points.");
        }
        rect.setTopLeftCorner(new Vector2i((double)pSW.getFloorX(), Math.ceil(pSW.getY())));
        rect.setBottomRightCorner(new Vector2i(Math.ceil(pNE.getX()), (double)pNE.getFloorY()));
    }

    public static double getDistanceBetweenPointsSquared(Vector3d point1, Vector3d point2) {
        return Math.pow(point2.getFloorX() - point1.getFloorX(), 2.0) + Math.pow(point2.getFloorZ() - point1.getFloorZ(), 2.0);
    }

    public static boolean pointInRectangle(Vector3d point, Rectangle rect) {
        return MathUtils.pointInRectangle(point.toVector2(true), rect);
    }

    public static boolean pointInRectangle(Vector2d point, Rectangle rect) {
        return (double)rect.maxY() >= point.getY() && point.getY() >= (double)rect.minY() && (double)rect.maxX() >= point.getX() && point.getX() >= (double)rect.minX();
    }

    public static boolean overlaps(Rectangle a, Rectangle b) {
        return b.minY() < a.maxY() && b.minX() < a.maxX() && b.maxY() > a.minY() && b.maxX() > a.minX();
    }

    public static boolean contains(Rectangle a, Rectangle b) {
        return a.maxY() >= b.maxY() && a.minY() <= b.minY() && a.maxX() >= b.maxX() && a.minX() <= b.minX();
    }

    public static boolean equals(Rectangle a, Rectangle b) {
        return a.getTopLeftCorner() == b.getTopLeftCorner() && a.getBottomRightCorner() == b.getBottomRightCorner();
    }

    public static boolean touches(Rectangle a, Rectangle b) {
        if ((a.minY() == b.maxY() || a.maxY() == b.minY()) && a.minX() <= b.maxX() && b.minX() <= a.maxX()) {
            return true;
        }
        return (a.minX() == b.maxX() || a.maxX() == b.minX()) && a.minY() <= b.maxY() && b.minY() <= a.maxY();
    }

    public static boolean borders(Rectangle a, Rectangle b) {
        if ((a.minY() == b.maxY() || a.maxY() == b.minY()) && a.minX() < b.maxX() && b.minX() < a.maxX()) {
            return true;
        }
        return (a.minX() == b.maxX() || a.maxX() == b.minX()) && a.minY() < b.maxY() && b.minY() < a.maxY();
    }

    public static int getWidth(Rectangle a) {
        return Math.abs(a.maxX() - a.minX());
    }

    public static int getHeight(Rectangle a) {
        return Math.abs(a.maxY() - a.minY());
    }

    public static int getShortestSide(Rectangle a) {
        return Math.min(MathUtils.getHeight(a), MathUtils.getWidth(a));
    }

    public static int getArea(Rectangle a) {
        return MathUtils.getHeight(a) * MathUtils.getWidth(a);
    }

    public static Vector2d getCenter(Rectangle a) {
        return Vector2d.from((double)((double)(a.maxX() + a.minX()) / 2.0), (double)((double)(a.maxY() + a.minY()) / 2.0));
    }

    public static double getDistanceSquaredToRectangle(Vector2d point, Rectangle rect) {
        Vector2d center = MathUtils.getCenter(rect);
        double pointXLength = Math.max(Math.abs(point.getX() - center.getX()) - (double)MathUtils.getWidth(rect) / 2.0, 0.0);
        double pointYLength = Math.max(Math.abs(point.getY() - center.getY()) - (double)MathUtils.getHeight(rect) / 2.0, 0.0);
        return Math.pow(pointXLength, 2.0) + Math.pow(pointYLength, 2.0);
    }

    public static double getDistanceSquaredToRectangle(Vector3d point, Rectangle rect) {
        return MathUtils.getDistanceSquaredToRectangle(point.toVector2(true), rect);
    }

    public static List<BasicRectangle> subtractRectangles(final Rectangle a, Rectangle b) {
        if (MathUtils.equals(a, b)) {
            return new ArrayList<BasicRectangle>();
        }
        if (MathUtils.contains(b, a)) {
            return new ArrayList<BasicRectangle>();
        }
        if (!MathUtils.overlaps(a, b)) {
            return new ArrayList<BasicRectangle>(){
                {
                    this.add(new BasicRectangle(a.getTopLeftCorner(), a.getBottomRightCorner()));
                }
            };
        }
        ArrayList<BasicRectangle> results = new ArrayList<BasicRectangle>();
        if (b.maxY() < a.maxY()) {
            results.add(new BasicRectangle(a.getTopLeftCorner(), Vector2i.from((int)a.maxX(), (int)b.maxY())));
        }
        if (b.minX() > a.minX()) {
            results.add(new BasicRectangle(Vector2i.from((int)a.minX(), (int)Math.min(a.maxY(), b.maxY())), Vector2i.from((int)b.minX(), (int)Math.max(a.minY(), b.minY()))));
        }
        if (b.maxX() < a.maxX()) {
            results.add(new BasicRectangle(Vector2i.from((int)b.maxX(), (int)Math.min(a.maxY(), b.maxY())), Vector2i.from((int)a.maxX(), (int)Math.max(a.minY(), b.minY()))));
        }
        if (b.minY() > a.minY()) {
            results.add(new BasicRectangle(Vector2i.from((int)a.minX(), (int)b.minY()), a.getBottomRightCorner()));
        }
        return results;
    }

    public static boolean rectangleContainedInSet(final Rectangle target, Set<? extends Rectangle> set) {
        ArrayList<Rectangle> remaining = new ArrayList<Rectangle>(){
            {
                this.add(target);
            }
        };
        for (Rectangle rectangle : set) {
            ListIterator iterator = remaining.listIterator();
            while (iterator.hasNext()) {
                Rectangle tar = (Rectangle)iterator.next();
                iterator.remove();
                MathUtils.subtractRectangles(tar, rectangle).forEach(iterator::add);
            }
        }
        return remaining.isEmpty();
    }

    public static double getDistanceToPlotSquared(Vector2i point, Rectangle plot) {
        int lengthX = MathUtils.getWidth(plot);
        int lengthZ = MathUtils.getHeight(plot);
        double centerX = (double)(plot.minX() + plot.maxX()) / 2.0;
        double centerZ = (double)(plot.minY() + plot.maxY()) / 2.0;
        double pointXLength = Math.max(Math.abs((double)point.getX() - centerX) - (double)lengthX / 2.0, 0.0);
        double pointYLength = Math.max(Math.abs((double)point.getY() - centerZ) - (double)lengthZ / 2.0, 0.0);
        return Math.pow(pointXLength, 2.0) + Math.pow(pointYLength, 2.0);
    }
}

