/*
 * Decompiled with CFR 0.152.
 */
package com.magitechserver.magibridge;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.magitechserver.magibridge.bridge.nucleus.NucleusBridgeImpl;
import com.magitechserver.magibridge.config.ConfigManager;
import com.magitechserver.magibridge.config.FormatType;
import com.magitechserver.magibridge.config.categories.ConfigCategory;
import com.magitechserver.magibridge.discord.DiscordMessageBuilder;
import com.magitechserver.magibridge.discord.MessageListener;
import com.magitechserver.magibridge.listeners.UChatListeners;
import com.magitechserver.magibridge.listeners.VanillaListeners;
import com.magitechserver.magibridge.util.ConsoleHandler;
import com.magitechserver.magibridge.util.Utils;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.security.auth.login.LoginException;
import magibridge.net.dv8tion.jda.api.JDA;
import magibridge.net.dv8tion.jda.api.JDABuilder;
import magibridge.net.dv8tion.jda.api.entities.Activity;
import magibridge.net.dv8tion.jda.api.entities.TextChannel;
import magibridge.net.dv8tion.jda.api.requests.GatewayIntent;
import magibridge.net.dv8tion.jda.api.utils.cache.CacheFlag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameStartingServerEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.Tristate;

@Plugin(id="magibridge", name="MagiBridge", description="A utility Discord <-> Minecraft chat relay plugin", authors={"Eufranio"}, dependencies={@Dependency(id="ultimatechat", optional=true), @Dependency(id="nucleus", optional=true), @Dependency(id="boop", version="[1.5.0,)", optional=true)})
public class MagiBridge {
    static MagiBridge instance = null;
    @Inject
    @ConfigDir(sharedRoot=false)
    public File configDir;
    @Inject
    private Logger logger;
    JDA jda;
    Task updaterTask;
    ConsoleHandler consoleHandler;
    ConfigCategory config;
    Executor executor;
    boolean useVanillaChat = false;

    @Listener
    public void onStartingServer(GameStartingServerEvent event) {
        instance = this;
        this.executor = Sponge.getScheduler().createAsyncExecutor((Object)this);
        ((CompletableFuture)this.init().thenRun(() -> {
            String startChannel = this.config.CHANNELS.START_MESSAGES_CHANNEL;
            if (startChannel.isEmpty()) {
                startChannel = this.config.CHANNELS.MAIN_CHANNEL;
            }
            DiscordMessageBuilder.forChannel(startChannel).format(FormatType.SERVER_STARTING).useWebhook(false).send();
            CommandSpec cs = CommandSpec.builder().description((Text)Text.of((String)"Broadcasts a message to the specified Discord channel name")).permission("magibridge.admin.broadcast").arguments(new CommandElement[]{GenericArguments.string((Text)Text.of((String)"channel")), GenericArguments.remainingJoinedStrings((Text)Text.of((String)"message"))}).executor((src, args) -> {
                String channel = (String)args.requireOne("channel");
                String message = (String)args.requireOne("message");
                ArrayList channels = this.jda.getTextChannelsByName(channel, true);
                if (channels.isEmpty() && (channels = Lists.newArrayList((Object[])new TextChannel[]{this.jda.getTextChannelById(channel)})).isEmpty()) {
                    throw new CommandException((Text)Text.of((String)"Could not send message! Are you sure a channel with this name/id exists?"));
                }
                channels.forEach(c -> DiscordMessageBuilder.forChannel(c.getId()).format(FormatType.of(() -> message)).useWebhook(false).send());
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Message sent!"}));
                return CommandResult.success();
            }).build();
            Sponge.getCommandManager().register((Object)MagiBridge.getInstance(), (CommandCallable)cs, new String[]{"mbroadcast", "mb"});
            if (this.config.CORE.ENABLE_CONSOLE_LOGGING && !this.config.CHANNELS.CONSOLE_CHANNEL.isEmpty()) {
                this.consoleHandler = new ConsoleHandler(this);
                this.consoleHandler.start();
                ((org.apache.logging.log4j.core.Logger)LogManager.getRootLogger()).addAppender((Appender)this.consoleHandler);
            }
        })).exceptionally(throwable -> {
            this.logger.error("Error loading MagiBridge: ", throwable.getCause());
            return null;
        });
        Sponge.getServiceManager().provide(PermissionService.class).ifPresent(svc -> {
            svc.getDefaults().getTransientSubjectData().setPermission((Set)Sets.newHashSet(), "magibridge.chat", Tristate.TRUE);
            svc.getDefaults().getTransientSubjectData().setPermission((Set)Sets.newHashSet(), "magibridge.mention", Tristate.TRUE);
        });
    }

    @Listener
    public void onStoppingServer(GameStoppingServerEvent event) {
        if (this.jda != null) {
            String startChannel = this.config.CHANNELS.START_MESSAGES_CHANNEL;
            if (startChannel.isEmpty()) {
                startChannel = this.config.CHANNELS.MAIN_CHANNEL;
            }
            DiscordMessageBuilder.forChannel(startChannel).format(FormatType.SERVER_STOPPING).useWebhook(false).send();
            if (this.updaterTask != null) {
                this.updaterTask.cancel();
            }
            this.jda.shutdown();
            long time = System.currentTimeMillis();
            while (System.currentTimeMillis() - time < 10000L && this.jda.getStatus() != JDA.Status.SHUTDOWN) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Listener
    public void reload(GameReloadEvent event) {
        ((CompletableFuture)((CompletableFuture)this.stop().thenCompose(v -> this.init())).thenRun(() -> this.logger.info("Plugin reloaded successfully!"))).exceptionally(throwable -> {
            this.logger.error("Error reloading MagiBridge: ", throwable.getCause());
            return null;
        });
    }

    CompletableFuture<Void> init() {
        return CompletableFuture.runAsync(() -> {
            this.config = new ConfigManager(instance).loadConfig();
            Utils.turnAllConfigChannelsNumeric();
            boolean throwException = false;
            try {
                this.jda = JDABuilder.create(this.config.CORE.BOT_TOKEN, GatewayIntent.GUILD_MEMBERS, GatewayIntent.GUILD_EMOJIS, GatewayIntent.GUILD_MESSAGES, GatewayIntent.DIRECT_MESSAGES).disableCache(CacheFlag.ACTIVITY, CacheFlag.VOICE_STATE, CacheFlag.CLIENT_STATUS).build().awaitReady();
                this.jda.addEventListener(new MessageListener());
            }
            catch (LoginException e) {
                throwException = true;
                this.logger.error("ERROR STARTING THE PLUGIN: THE TOKEN IN THE CONFIG IS INVALID!");
                this.logger.error("You probably didn't set the token yet, edit your config!");
            }
            catch (IllegalStateException e) {
                throwException = true;
                if (e.getMessage().contains("Was shutdown trying to await status")) {
                    this.logger.error("JDA couldn't start and didn't throw any errors. Make sure your bot has the SERVER MEMBERS INTENT enabled in the application page! See https://github.com/Eufranio/MagiBridge#how-to-magibridge");
                } else {
                    this.logger.error("Error connecting to discord. This is NOT a plugin error: " + e.getMessage());
                }
            }
            catch (Exception e) {
                throwException = true;
                this.logger.error("Error connecting to discord. This is NOT a plugin error: " + e.getMessage());
            }
            if (throwException) {
                RuntimeException exception = new RuntimeException("MagiBridge errored and could not start, check the logs for the error!");
                exception.setStackTrace(new StackTraceElement[0]);
                throw exception;
            }
        }, this.executor).thenRun(() -> {
            this.registerListeners();
            if (this.config.CORE.ENABLE_UPDATER && this.jda.getStatus() == JDA.Status.CONNECTED) {
                this.updaterTask = Task.builder().interval((long)Math.max(this.config.CORE.UPDATER_INTERVAL, 10), TimeUnit.MINUTES).execute(() -> {
                    TextChannel channel;
                    String channelId = this.config.CHANNELS.TOPIC_UPDATER_CHANNEL;
                    if (channelId.isEmpty()) {
                        channelId = this.config.CHANNELS.MAIN_CHANNEL;
                    }
                    if ((channel = this.jda.getTextChannelById(channelId)) == null) {
                        this.logger.error("The main-discord-channel is INVALID, replace it with a valid one and restart the server!");
                        return;
                    }
                    Function<String, String> replace = s -> s.replace("%players%", "" + Sponge.getServer().getOnlinePlayers().stream().filter(p -> p.get(Keys.VANISH).orElse(false) == false).count()).replace("%maxplayers%", Integer.valueOf(Sponge.getServer().getMaxPlayers()).toString()).replace("%tps%", Long.valueOf(Math.round(Sponge.getServer().getTicksPerSecond())).toString()).replace("%daysonline%", Long.valueOf(ManagementFactory.getRuntimeMXBean().getUptime() / 86400000L).toString()).replace("%hoursonline%", Long.valueOf(ManagementFactory.getRuntimeMXBean().getUptime() / 3600000L % 24L).toString()).replace("%minutesonline%", Long.valueOf(ManagementFactory.getRuntimeMXBean().getUptime() / 60000L % 60L).toString());
                    String topic = replace.apply(FormatType.TOPIC_FORMAT.get());
                    channel.getManager().setTopic(topic).queue();
                    if (!this.config.MESSAGES.BOT_GAME_STATUS.isEmpty()) {
                        String msg = replace.apply(this.config.MESSAGES.BOT_GAME_STATUS);
                        Activity activity = this.jda.getPresence().getActivity();
                        if (activity != null && activity.getName().equals(msg)) {
                            return;
                        }
                        this.jda.getPresence().setActivity(Activity.playing(msg));
                    }
                }).submit((Object)this);
            }
        });
    }

    CompletableFuture<Void> stop() {
        if (this.updaterTask != null) {
            this.updaterTask.cancel();
        }
        Sponge.getEventManager().unregisterPluginListeners((Object)this);
        Sponge.getEventManager().registerListeners((Object)this, (Object)this);
        return CompletableFuture.runAsync(() -> {
            this.logger.info("Disconnecting from Discord...");
            if (this.jda != null && this.jda.getStatus() != JDA.Status.SHUTDOWN && this.jda.getStatus() != JDA.Status.SHUTTING_DOWN) {
                this.jda.shutdownNow();
            }
            this.config = null;
        }).exceptionally(throwable -> {
            this.logger.error("Error stopping MagiBridge: ", throwable.getCause());
            return null;
        });
    }

    private void registerListeners() {
        NucleusBridgeImpl.init(this);
        if (this.config.CHANNELS.USE_NUCLEUS) {
            this.useVanillaChat = true;
            if (Sponge.getPluginManager().getPlugin("nucleus").isPresent()) {
                this.logger.info("Hooking into Nucleus");
            } else {
                this.logger.error(" ");
                this.logger.error(" MagiBridge is configured to hook into Nucleus, but it isn't loaded! Please disable using-nucleus or load Nucleus on your server!");
                this.logger.error(" ");
            }
        } else if (this.config.CHANNELS.USE_UCHAT) {
            if (Sponge.getPluginManager().getPlugin("ultimatechat").isPresent()) {
                Sponge.getEventManager().registerListeners((Object)this, (Object)new UChatListeners(this));
                this.logger.info("Hooking into UltimateChat");
            } else {
                this.logger.error(" ");
                this.logger.error(" MagiBridge is configured to hook into UltimateChat, but it isn't loaded! Please disable using-ultimatechat or load UltimateChat on your server!");
                this.logger.error(" ");
                this.useVanillaChat = true;
            }
        } else {
            this.logger.info(" No Chat Hook enabled, hooking into the vanilla chat system");
            this.logger.info(" Some features may not work, and there will be no staff chat. If you want a more complete chat handling, use either Nucleus or UltimateChat.");
            this.useVanillaChat = true;
        }
        Sponge.getEventManager().registerListeners((Object)this, (Object)new VanillaListeners(this));
    }

    public List<String> getListeningChannels() {
        ArrayList channels = Lists.newArrayList();
        if (this.config.CORE.ENABLE_CONSOLE_LOGGING && !this.config.CHANNELS.CONSOLE_CHANNEL.isEmpty()) {
            channels.add(this.config.CHANNELS.CONSOLE_CHANNEL);
        }
        if (this.config.CHANNELS.USE_UCHAT) {
            channels.addAll(this.config.CHANNELS.UCHAT.UCHAT_CHANNELS.keySet());
        }
        if (this.config.CHANNELS.USE_NUCLEUS) {
            channels.add(this.config.CHANNELS.NUCLEUS.GLOBAL_CHANNEL);
            channels.add(this.config.CHANNELS.NUCLEUS.STAFF_CHANNEL);
            if (!this.config.CHANNELS.NUCLEUS.HELPOP_CHANNEL.isEmpty()) {
                channels.add(this.config.CHANNELS.NUCLEUS.HELPOP_CHANNEL);
            }
            if (!this.config.CHANNELS.NUCLEUS.AFK_MESSAGES_CHANNEL.isEmpty()) {
                channels.add(this.config.CHANNELS.NUCLEUS.AFK_MESSAGES_CHANNEL);
            }
        }
        if (!this.config.CHANNELS.MAIN_CHANNEL.isEmpty()) {
            channels.add(this.config.CHANNELS.MAIN_CHANNEL);
        }
        if (!this.config.CHANNELS.JOIN_MESSAGES_CHANNEL.isEmpty()) {
            channels.add(this.config.CHANNELS.JOIN_MESSAGES_CHANNEL);
        }
        if (!this.config.CHANNELS.ADVANCEMENT_MESSAGES_CHANNEL.isEmpty()) {
            channels.add(this.config.CHANNELS.ADVANCEMENT_MESSAGES_CHANNEL);
        }
        if (!this.config.CHANNELS.DEATH_MESSAGES_CHANNEL.isEmpty()) {
            channels.add(this.config.CHANNELS.DEATH_MESSAGES_CHANNEL);
        }
        if (!this.config.CHANNELS.WELCOME_MESSAGES_CHANNEL.isEmpty()) {
            channels.add(this.config.CHANNELS.WELCOME_MESSAGES_CHANNEL);
        }
        if (!this.config.CHANNELS.TOPIC_UPDATER_CHANNEL.isEmpty()) {
            channels.add(this.config.CHANNELS.TOPIC_UPDATER_CHANNEL);
        }
        if (!this.config.CHANNELS.START_MESSAGES_CHANNEL.isEmpty()) {
            channels.add(this.config.CHANNELS.START_MESSAGES_CHANNEL);
        }
        return channels;
    }

    public boolean enableVanillaChat() {
        return this.useVanillaChat;
    }

    public ConfigCategory getConfig() {
        return this.config;
    }

    public JDA getJDA() {
        return this.jda;
    }

    public static MagiBridge getInstance() {
        return instance;
    }

    public static Logger getLogger() {
        return MagiBridge.instance.logger;
    }
}

