/*
 * Decompiled with CFR 0.152.
 */
package com.magitechserver.magibridge.chat;

import br.net.fabiozumbi12.UltimateChat.Sponge.UCChannel;
import br.net.fabiozumbi12.UltimateChat.Sponge.UChat;
import com.google.common.collect.Maps;
import com.magitechserver.magibridge.MagiBridge;
import com.magitechserver.magibridge.chat.MessageBuilder;
import com.magitechserver.magibridge.common.NucleusBridge;
import com.magitechserver.magibridge.config.FormatType;
import com.magitechserver.magibridge.config.categories.ConfigCategory;
import com.magitechserver.magibridge.config.categories.Messages;
import com.magitechserver.magibridge.events.DiscordMessageEvent;
import com.magitechserver.magibridge.util.TextHelper;
import com.magitechserver.magibridge.util.Utils;
import flavor.pie.boop.BoopableChannel;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import magibridge.net.dv8tion.jda.api.entities.Message;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.format.TextColors;

public class ServerMessageBuilder
implements MessageBuilder {
    public static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)[\u00a7&][0-9A-FK-OR]");
    private boolean staff = false;
    private boolean colors = true;
    private FormatType format;
    private Map<String, String> placeholders = Maps.newHashMap();
    private List<Message.Attachment> attachments;
    private String channel;

    public static ServerMessageBuilder create() {
        return new ServerMessageBuilder();
    }

    public ServerMessageBuilder staff(boolean staff) {
        this.staff = staff;
        return this;
    }

    public ServerMessageBuilder format(FormatType format) {
        this.format = format;
        return this;
    }

    public ServerMessageBuilder placeholder(String name, String value) {
        this.placeholders.put("%" + name + "%", value);
        return this;
    }

    public ServerMessageBuilder attachments(List<Message.Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public ServerMessageBuilder channel(String channel) {
        this.channel = channel;
        return this;
    }

    public ServerMessageBuilder colors(boolean colors) {
        this.colors = colors;
        return this;
    }

    @Override
    public MessageBuilder.Type getType() {
        return MessageBuilder.Type.DISCORD_TO_SERVER;
    }

    public void send() {
        Text toSend;
        Object messageChannel;
        if (Sponge.getEventManager().post((Event)new DiscordMessageEvent(this))) {
            return;
        }
        if (!this.colors) {
            this.placeholders.compute("%message%", (k, v) -> v != null ? STRIP_COLOR_PATTERN.matcher((CharSequence)v).replaceAll("") : v);
        }
        boolean isUchat = this.channel != null;
        ConfigCategory config = MagiBridge.getInstance().getConfig();
        Text prefix = Text.of();
        if (config.MESSAGES.PREFIX.ENABLED) {
            Messages.PrefixCategory category = config.MESSAGES.PREFIX;
            try {
                prefix = Utils.toText(category.TEXT).toBuilder().onHover((HoverAction)TextActions.showText((Text)Utils.toText(category.HOVER))).onClick((ClickAction)TextActions.openUrl((URL)new URL(category.LINK))).build();
            }
            catch (MalformedURLException e) {
                MagiBridge.getLogger().error(category.LINK + " is an invalid prefix URL! Fix it on your config!");
                return;
            }
        }
        Text attachment = Text.of();
        if (this.attachments != null && !this.attachments.isEmpty()) {
            LiteralText.Builder hover = Text.builder((String)"Attachments: ").append(new Text[]{Text.NEW_LINE});
            for (Message.Attachment att : this.attachments) {
                hover.append(new Text[]{Text.of((Object[])new Object[]{att.getFileName(), Text.NEW_LINE})});
            }
            hover.append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, "Click to open this attachment!"})});
            URL url = null;
            try {
                url = new URL(this.attachments.get(0).getUrl());
            }
            catch (MalformedURLException att) {
                // empty catch block
            }
            attachment = Text.builder().append(new Text[]{Utils.toText(config.MESSAGES.ATTACHMENT_NAME)}).onHover((HoverAction)TextActions.showText((Text)hover.build())).onClick((ClickAction)(url != null ? TextActions.openUrl((URL)url) : null)).build();
        }
        if (isUchat && config.CHANNELS.USE_UCHAT && Sponge.getPluginManager().isLoaded("ultimatechat")) {
            String rawFormat = config.CHANNELS.UCHAT.UCHAT_OVERRIDES.getOrDefault(this.channel, this.format.get());
            UCChannel chatChannel = UChat.get().getAPI().getChannels().stream().filter(c -> c.getName().equalsIgnoreCase(this.channel)).findFirst().orElse(null);
            if (chatChannel == null) {
                MagiBridge.getLogger().error("The channel " + this.channel + " specified in the config doesn't exist in-game!");
                return;
            }
            Text text = Text.of((Object[])new Object[]{prefix, Utils.toText(Utils.replaceEach(rawFormat, this.placeholders)), attachment});
            text = TextHelper.replaceLink(text);
            chatChannel.sendMessage(Sponge.getServer().getConsole(), text, true);
        } else if (config.CHANNELS.USE_NUCLEUS && Sponge.getPluginManager().isLoaded("nucleus")) {
            if (!this.staff) {
                messageChannel = Sponge.getPluginManager().getPlugin("boop").isPresent() && config.CORE.USE_BOOP ? new BoopableChannel(MessageChannel.TO_ALL) : MessageChannel.TO_ALL;
            } else {
                messageChannel = NucleusBridge.getInstance().getStaffChannel();
                this.format = FormatType.DISCORD_TO_SERVER_STAFF_FORMAT;
            }
            toSend = Text.of((Object[])new Object[]{prefix, Utils.toText(this.format.format(this.placeholders)), attachment});
            toSend = TextHelper.replaceLink(toSend);
            messageChannel.send(toSend);
        } else {
            messageChannel = Sponge.getPluginManager().getPlugin("boop").isPresent() ? new BoopableChannel(MessageChannel.TO_ALL) : MessageChannel.TO_ALL;
            toSend = Text.of((Object[])new Object[]{prefix, Utils.toText(this.format.format(this.placeholders)), attachment});
            toSend = TextHelper.replaceLink(toSend);
            messageChannel.send(toSend);
        }
    }
}

