/*
 * Decompiled with CFR 0.152.
 */
package com.magitechserver.magibridge.common;

import com.magitechserver.magibridge.common.EmptyNucleusDelegate;
import com.magitechserver.magibridge.common.NucleusBridgeDelegate;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;

public abstract class NucleusBridge {
    protected static NucleusBridge instance;
    protected NucleusBridgeDelegate delegate;

    public void init(Object plugin, boolean nucleusAvailable) {
        if (nucleusAvailable) {
            try {
                Class.forName("io.github.nucleuspowered.nucleus.api.events.NucleusAFKEvent");
                this.delegate = (NucleusBridgeDelegate)Class.forName("com.magitechserver.magibridge.nucleusv1.NucleusV1Handlers").newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                try {
                    this.delegate = (NucleusBridgeDelegate)Class.forName("com.magitechserver.magibridge.nucleusv2.NucleusV2Handlers").newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    this.delegate = new EmptyNucleusDelegate();
                }
            }
        } else {
            this.delegate = new EmptyNucleusDelegate();
        }
        Sponge.getEventManager().registerListeners(plugin, (Object)this.delegate);
    }

    public abstract Text getNick(UUID var1);

    public abstract void onAfk(Player var1, boolean var2);

    public abstract void onHelpOp(Player var1, Text var2);

    public abstract void onBroadcast(Text var1, Text var2, Text var3);

    public boolean isStaffChatEnabled() {
        return this.delegate.isStaffChatEnabled();
    }

    public boolean isDirectedToStaffChannel(MessageChannelEvent.Chat event) {
        return this.delegate.isDirectedToStaffChannel(event);
    }

    public MessageChannel getStaffChannel() {
        return this.delegate.getStaffChannel();
    }

    public Text replacePlaceholders(String string, CommandSource commandSource) {
        return this.delegate.replacePlaceholders(string, commandSource);
    }

    public static NucleusBridge getInstance() {
        return instance;
    }
}

