/*
 * Decompiled with CFR 0.152.
 */
package com.magitechserver.magibridge.discord;

import com.google.common.collect.Maps;
import com.magitechserver.magibridge.MagiBridge;
import com.magitechserver.magibridge.chat.MessageBuilder;
import com.magitechserver.magibridge.chat.ServerMessageBuilder;
import com.magitechserver.magibridge.common.NucleusBridge;
import com.magitechserver.magibridge.config.FormatType;
import com.magitechserver.magibridge.discord.WebhookManager;
import com.magitechserver.magibridge.events.DiscordMessageEvent;
import com.magitechserver.magibridge.util.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import magibridge.net.dv8tion.jda.api.JDA;
import magibridge.net.dv8tion.jda.api.entities.Emote;
import magibridge.net.dv8tion.jda.api.entities.Guild;
import magibridge.net.dv8tion.jda.api.entities.Member;
import magibridge.net.dv8tion.jda.api.entities.Message;
import magibridge.net.dv8tion.jda.api.entities.Role;
import magibridge.net.dv8tion.jda.api.entities.TextChannel;
import me.rojo8399.placeholderapi.PlaceholderService;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;

public class DiscordMessageBuilder
implements MessageBuilder {
    private String channel;
    private FormatType formatType;
    private boolean useWebhook = true;
    private boolean allowMentions = true;
    private boolean allowEveryone = false;
    private boolean allowHere = false;
    private boolean queue = true;
    private int deleteTime = -1;
    private Map<String, String> placeholders = Maps.newHashMap();
    private char[] bannedCharacters = new char[]{'\u202e', '\u202d', '\u202a', '\u202b', '\u202c'};

    public static DiscordMessageBuilder forChannel(String channel) {
        return new DiscordMessageBuilder(channel);
    }

    private DiscordMessageBuilder(String channel) {
        this.channel = channel;
    }

    public DiscordMessageBuilder format(FormatType format) {
        this.formatType = format;
        return this;
    }

    public DiscordMessageBuilder placeholder(String name, String value) {
        this.placeholders.put("%" + name + "%", value);
        return this;
    }

    public DiscordMessageBuilder placeholders(Map<String, String> placeholders) {
        placeholders.forEach(this::placeholder);
        return this;
    }

    public DiscordMessageBuilder useWebhook(boolean use) {
        this.useWebhook = use;
        return this;
    }

    public DiscordMessageBuilder allowMentions(boolean allow) {
        this.allowMentions = allow;
        return this;
    }

    public DiscordMessageBuilder allowEveryone(boolean allow) {
        this.allowEveryone = allow;
        return this;
    }

    public DiscordMessageBuilder allowHere(boolean allow) {
        this.allowHere = allow;
        return this;
    }

    public DiscordMessageBuilder queue(boolean queue) {
        this.queue = queue;
        return this;
    }

    @Override
    public MessageBuilder.Type getType() {
        return MessageBuilder.Type.SERVER_TO_DISCORD;
    }

    public String get() {
        List usersMentioned;
        JDA jda = MagiBridge.getInstance().getJDA();
        if (jda == null || jda.getStatus() != JDA.Status.CONNECTED) {
            return null;
        }
        TextChannel textChannel = jda.getTextChannelById(this.channel.replace("#", ""));
        if (textChannel == null) {
            MagiBridge.getLogger().error("The channel " + this.channel + " defined in the config isn't a valid Discord Channel ID!");
            MagiBridge.getLogger().error("Replace it with a valid one and then reload the plugin!");
            return null;
        }
        if (Sponge.getEventManager().post((Event)new DiscordMessageEvent(this))) {
            return null;
        }
        this.placeholders.computeIfPresent("%message%", (placeholder, value) -> {
            for (char ch : this.bannedCharacters) {
                value = value.replace(Character.toString(ch), "");
            }
            return Utils.replaceEach(value, MagiBridge.getInstance().getConfig().REPLACER.mcToDiscordReplacer);
        });
        ConsoleSource source = Sponge.getServer().getConsole();
        if (this.placeholders.get("%player%") != null) {
            source = (CommandSource)Sponge.getServer().getPlayer(this.placeholders.get("%player%")).get();
        }
        String message = this.parsePlaceholders(this.formatType, (CommandSource)source);
        if (this.useWebhook && MagiBridge.getInstance().getConfig().CHANNELS.USE_WEBHOOKS) {
            message = this.placeholders.get("%message%").replaceAll(ServerMessageBuilder.STRIP_COLOR_PATTERN.pattern(), "");
        }
        Guild guild = textChannel.getGuild();
        for (Emote emote : guild.getEmotes()) {
            message = message.replace(":" + emote.getName() + ":", emote.getAsMention());
        }
        if (this.allowMentions && !(usersMentioned = Arrays.stream(message.split(" ")).filter(word -> word.startsWith("@")).map(s -> s.substring(1)).collect(Collectors.toList())).isEmpty()) {
            for (String user : usersMentioned) {
                if (user.trim().isEmpty()) continue;
                List users = textChannel.getGuild().getMembers().stream().filter(m -> m.getEffectiveName().equalsIgnoreCase(user)).collect(Collectors.toList());
                List<Role> roles = textChannel.getGuild().getRolesByName(user, true);
                if (!users.isEmpty()) {
                    message = message.replace("@" + user, ((Member)users.get(0)).getAsMention().replace("!", ""));
                }
                if (roles.isEmpty()) continue;
                message = message.replace("@" + user, roles.get(0).getAsMention());
            }
        }
        if (!this.allowEveryone) {
            message = message.replace("@everyone", "everyone");
        }
        if (!this.allowHere) {
            message = message.replace("@here", "here");
        }
        if (message.isEmpty()) {
            return null;
        }
        return message;
    }

    public void send() {
        String message = this.get();
        if (message == null) {
            return;
        }
        TextChannel textChannel = MagiBridge.getInstance().getJDA().getTextChannelById(this.channel.replace("#", ""));
        if (this.deleteTime != -1) {
            if (this.queue) {
                textChannel.sendMessage(message).queue(m -> m.delete().queueAfter(this.deleteTime, TimeUnit.SECONDS));
            } else {
                ((Message)textChannel.sendMessage(message).complete()).delete().queueAfter(this.deleteTime, TimeUnit.SECONDS);
            }
        } else if (this.useWebhook && MagiBridge.getInstance().getConfig().CHANNELS.USE_WEBHOOKS) {
            Player player = (Player)Sponge.getServer().getPlayer(this.placeholders.get("%player%")).get();
            String placeholderName = this.parsePlaceholders(FormatType.WEBHOOK_NAME, (CommandSource)player);
            WebhookManager.sendWebhookMessage(placeholderName, player.getName(), message, this.channel);
        } else if (this.queue) {
            textChannel.sendMessage(message).queue();
        } else {
            textChannel.sendMessage(message).complete();
        }
    }

    String parsePlaceholders(FormatType format, CommandSource source) {
        String rawMessage = this.placeholders.remove("%message%");
        if (rawMessage != null) {
            rawMessage = rawMessage.replace("%message%", "");
        }
        String message = format.format(this.placeholders);
        if (Sponge.getPluginManager().isLoaded("placeholderapi")) {
            PlaceholderService service = (PlaceholderService)Sponge.getServiceManager().provideUnchecked(PlaceholderService.class);
            message = service.replacePlaceholders(message, (Object)source, null).toPlain();
        }
        if (Sponge.getPluginManager().isLoaded("nucleus")) {
            message = NucleusBridge.getInstance().replacePlaceholders(message, source).toPlain();
        }
        if (rawMessage != null) {
            message = message.replace("{message}", rawMessage).replace("%message%", rawMessage);
        }
        this.placeholder("message", rawMessage);
        message = message.replaceAll(ServerMessageBuilder.STRIP_COLOR_PATTERN.pattern(), "");
        return message;
    }
}

