/*
 * Decompiled with CFR 0.152.
 */
package com.magitechserver.magibridge.discord;

import com.magitechserver.magibridge.MagiBridge;
import com.magitechserver.magibridge.discord.WebhookContent;
import magibridge.com.mashape.unirest.http.Unirest;
import magibridge.net.dv8tion.jda.api.Permission;
import magibridge.net.dv8tion.jda.api.entities.TextChannel;
import magibridge.net.dv8tion.jda.api.entities.Webhook;
import magibridge.org.json.JSONObject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.Task;

public class WebhookManager {
    public static void sendWebhookMessage(String hook, String player, String message, String channelID) {
        Player p = (Player)Sponge.getServer().getPlayer(player).get();
        String format = MagiBridge.getInstance().getConfig().MESSAGES.WEBHOOK_PICTURE_URL.replace("%player%", player).replace("%uuid%", p.getUniqueId().toString());
        Task.builder().async().execute(() -> {
            Webhook webhook = WebhookManager.getWebhook(channelID);
            if (webhook == null) {
                return;
            }
            WebhookManager.sendWebhook(webhook, WebhookContent.of(format, hook, message));
        }).submit((Object)MagiBridge.getInstance());
    }

    public static void sendWebhook(Webhook webhook, WebhookContent content) {
        JSONObject json = new JSONObject();
        json.put("content", content.message);
        json.put("username", content.name.replaceAll("&([0-9a-fA-FlLkKrR])", ""));
        json.put("avatar_url", content.avatarUrl);
        try {
            Unirest.post(webhook.getUrl()).header("Content-Type", "application/json").body(json).asJson();
        }
        catch (Exception e) {
            MagiBridge.getLogger().error("Error delivering Webhook request: ");
            e.printStackTrace();
        }
    }

    private static Webhook getWebhook(String channelID) {
        TextChannel channel = MagiBridge.getInstance().getJDA().getTextChannelById(channelID);
        if (!channel.getGuild().getSelfMember().hasPermission(Permission.MANAGE_WEBHOOKS)) {
            MagiBridge.getLogger().error("The bot does not have the MANAGE WEBHOOKS permission, so it can't create webhooks!");
            MagiBridge.getLogger().error("Please give it or disable the use-webhooks feature!");
            return null;
        }
        Webhook webhook = channel.getGuild().retrieveWebhooks().complete().stream().filter(wh -> wh.getName().equals("MB: " + channel.getName())).findFirst().orElse(null);
        if (webhook == null) {
            webhook = (Webhook)channel.createWebhook("MB: " + channel.getName()).complete();
        }
        return webhook;
    }
}

