/*
 * Decompiled with CFR 0.152.
 */
package com.magitechserver.magibridge.listeners;

import com.arckenver.nations.channel.NationMessageChannel;
import com.magitechserver.magibridge.MagiBridge;
import com.magitechserver.magibridge.common.NucleusBridge;
import com.magitechserver.magibridge.config.FormatType;
import com.magitechserver.magibridge.discord.DiscordMessageBuilder;
import com.magitechserver.magibridge.util.Utils;
import io.github.aquerr.eaglefactions.api.messaging.chat.AllianceMessageChannel;
import io.github.aquerr.eaglefactions.api.messaging.chat.FactionMessageChannel;
import nl.riebie.mcclans.channels.AllyMessageChannelImpl;
import nl.riebie.mcclans.channels.ClanMessageChannelImpl;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.advancement.AdvancementEvent;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.type.FixedMessageChannel;

public class VanillaListeners {
    MagiBridge plugin;

    public VanillaListeners(MagiBridge plugin) {
        this.plugin = plugin;
    }

    @Listener
    public void onAdvancement(AdvancementEvent.Grant event, @Getter(value="getTargetEntity") Player p) {
        if (!p.hasPermission("magibridge.chat")) {
            return;
        }
        if (!this.plugin.getConfig().CORE.ADVANCEMENT_MESSAGES_ENABLED) {
            return;
        }
        if (event.getAdvancement().getName().startsWith("recipes")) {
            return;
        }
        String channel = this.plugin.getConfig().CHANNELS.ADVANCEMENT_MESSAGES_CHANNEL;
        if (channel.isEmpty()) {
            channel = this.plugin.getConfig().CHANNELS.MAIN_CHANNEL;
        }
        DiscordMessageBuilder.forChannel(channel).placeholders(Utils.playerPlaceholders(p)).placeholder("advancement", event.getAdvancement().getName()).useWebhook(false).format(FormatType.ADVANCEMENT_MESSAGE).send();
    }

    @Listener
    public void onDeath(DestructEntityEvent.Death event) {
        if (event.getTargetEntity() instanceof Player && this.plugin.getConfig().CORE.DEATH_MESSAGES_ENABLED) {
            if (event.getMessage().toPlain().isEmpty()) {
                return;
            }
            Player p = (Player)event.getTargetEntity();
            if (!p.hasPermission("magibridge.chat")) {
                return;
            }
            String channel = this.plugin.getConfig().CHANNELS.DEATH_MESSAGES_CHANNEL;
            if (channel.isEmpty()) {
                channel = this.plugin.getConfig().CHANNELS.MAIN_CHANNEL;
            }
            DiscordMessageBuilder.forChannel(channel).placeholders(Utils.playerPlaceholders(p)).placeholder("deathmessage", event.getMessage().toPlain()).useWebhook(false).format(FormatType.DEATH_MESSAGE).send();
        }
    }

    @Listener(order=Order.LAST)
    public void onSpongeMessage(MessageChannelEvent.Chat e, @Root Player p) {
        MessageChannel messageChannel;
        if (!this.plugin.enableVanillaChat()) {
            return;
        }
        if (!p.hasPermission("magibridge.chat")) {
            return;
        }
        if (!Sponge.getServer().getOnlinePlayers().contains(p) || e.isMessageCancelled()) {
            return;
        }
        if (e.getCause().first(PluginContainer.class).filter(container -> container.getId().contains("nucleus")).isPresent() && !NucleusBridge.getInstance().isDirectedToStaffChannel(e)) {
            return;
        }
        if (this.plugin.getConfig().CORE.HIDE_VANISHED_CHAT && p.get(Keys.VANISH).orElse(false).booleanValue()) {
            return;
        }
        FormatType format = FormatType.SERVER_TO_DISCORD_FORMAT;
        String channel = this.plugin.getConfig().CHANNELS.MAIN_CHANNEL;
        if (e.getChannel().isPresent()) {
            boolean nationsLoaded;
            messageChannel = (MessageChannel)e.getChannel().get();
            boolean bl = nationsLoaded = Sponge.getPluginManager().isLoaded("nations") || Sponge.getPluginManager().isLoaded("nations-updated");
            if (nationsLoaded && messageChannel instanceof NationMessageChannel) {
                return;
            }
            if (Sponge.getPluginManager().isLoaded("eaglefactions")) {
                try {
                    Class.forName("io.github.aquerr.eaglefactions.api.messaging.chat.AllianceMessageChannel");
                    if (messageChannel instanceof AllianceMessageChannel || messageChannel instanceof FactionMessageChannel) {
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (Sponge.getPluginManager().isLoaded("mcclans") && (messageChannel instanceof AllyMessageChannelImpl || messageChannel instanceof ClanMessageChannelImpl)) {
                return;
            }
        }
        if (this.plugin.getConfig().CHANNELS.USE_NUCLEUS && Sponge.getPluginManager().isLoaded("nucleus") && e.getChannel().isPresent()) {
            messageChannel = (MessageChannel)e.getChannel().get();
            if (!NucleusBridge.getInstance().isStaffChatEnabled()) {
                MagiBridge.getLogger().error("The staff chat module is disabled in the Nucleus config! Please enable it!");
                return;
            }
            boolean isStaffMessage = NucleusBridge.getInstance().isDirectedToStaffChannel(e);
            if (!isStaffMessage && messageChannel instanceof FixedMessageChannel && !messageChannel.getMembers().containsAll(Sponge.getServer().getBroadcastChannel().getMembers())) {
                return;
            }
            String string = channel = isStaffMessage ? this.plugin.getConfig().CHANNELS.NUCLEUS.STAFF_CHANNEL : this.plugin.getConfig().CHANNELS.NUCLEUS.GLOBAL_CHANNEL;
            if (channel.isEmpty()) {
                return;
            }
            format = isStaffMessage ? FormatType.SERVER_TO_DISCORD_STAFF_FORMAT : FormatType.SERVER_TO_DISCORD_FORMAT;
        }
        DiscordMessageBuilder.forChannel(channel).placeholders(Utils.playerPlaceholders(p)).placeholder("message", e.getFormatter().getBody().toText().toPlain()).format(format).allowEveryone(p.hasPermission("magibridge.everyone")).allowHere(p.hasPermission("magibridge.here")).allowMentions(p.hasPermission("magibridge.mention")).send();
    }

    @Listener
    public void onLogin(ClientConnectionEvent.Join event, @Getter(value="getTargetEntity") Player p) {
        if (!p.hasPermission("magibridge.chat")) {
            return;
        }
        if (!p.hasPlayedBefore()) {
            String channel = this.plugin.getConfig().CHANNELS.WELCOME_MESSAGES_CHANNEL;
            if (channel.isEmpty()) {
                channel = this.plugin.getConfig().CHANNELS.MAIN_CHANNEL;
            }
            DiscordMessageBuilder.forChannel(channel).placeholders(Utils.playerPlaceholders(p)).useWebhook(false).format(FormatType.NEW_PLAYERS_MESSAGE).send();
            return;
        }
        if (p.hasPermission("magibridge.silentjoin")) {
            MagiBridge.getLogger().warn("The player " + p.getName() + " has the magibridge.silentjoin permission, not sending join message!");
            return;
        }
        String channel = this.plugin.getConfig().CHANNELS.JOIN_MESSAGES_CHANNEL;
        if (channel.isEmpty()) {
            channel = this.plugin.getConfig().CHANNELS.MAIN_CHANNEL;
        }
        DiscordMessageBuilder.forChannel(channel).placeholders(Utils.playerPlaceholders(p)).useWebhook(false).format(FormatType.JOIN_MESSAGE).send();
    }

    @Listener
    public void onQuit(ClientConnectionEvent.Disconnect event, @Getter(value="getTargetEntity") Player p) {
        if (!p.hasPermission("magibridge.chat")) {
            return;
        }
        String channel = this.plugin.getConfig().CHANNELS.JOIN_MESSAGES_CHANNEL;
        if (channel.isEmpty()) {
            channel = this.plugin.getConfig().CHANNELS.MAIN_CHANNEL;
        }
        if (p.hasPermission("magibridge.silentquit")) {
            MagiBridge.getLogger().warn("The player " + p.getName() + " has the magibridge.silentjoin permission, not sending join message!");
            return;
        }
        DiscordMessageBuilder.forChannel(channel).placeholders(Utils.playerPlaceholders(p)).useWebhook(false).format(FormatType.QUIT_MESSAGE).send();
    }
}

