/*
 * Decompiled with CFR 0.152.
 */
package com.magitechserver.magibridge.util;

import com.magitechserver.magibridge.MagiBridge;
import com.magitechserver.magibridge.config.FormatType;
import com.magitechserver.magibridge.discord.DiscordMessageBuilder;
import java.util.concurrent.TimeUnit;
import magibridge.net.dv8tion.jda.api.JDA;
import magibridge.net.dv8tion.jda.api.MessageBuilder;
import magibridge.net.dv8tion.jda.api.entities.Message;
import magibridge.net.dv8tion.jda.api.entities.TextChannel;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.spongepowered.api.scheduler.Task;

public class ConsoleHandler
extends AbstractAppender {
    MessageBuilder messageBuilder = new MessageBuilder();
    MagiBridge plugin;

    public ConsoleHandler(MagiBridge plugin) {
        super("MagiBridgeConsoleWatcher", null, null);
        this.plugin = plugin;
        Task.builder().interval(2L, TimeUnit.SECONDS).execute(this::sendMessages).submit((Object)MagiBridge.getInstance());
    }

    public void append(LogEvent event) {
        if (!event.getLevel().isInRange(Level.FATAL, Level.INFO)) {
            return;
        }
        FormatType format = FormatType.SERVER_CONSOLE_TO_DISCORD_FORMAT;
        if (this.plugin.getConfig() == null) {
            return;
        }
        String channel = this.plugin.getConfig().CHANNELS.CONSOLE_CHANNEL;
        String msg = DiscordMessageBuilder.forChannel(channel).placeholder("threadname", event.getThreadName()).placeholder("loglevel", event.getLevel().name()).placeholder("loggername", event.getLoggerName()).placeholder("message", event.getMessage().getFormattedMessage()).format(format).useWebhook(false).get();
        if (msg == null) {
            return;
        }
        this.messageBuilder.append(msg).append('\n');
    }

    public void sendMessages() {
        if (this.messageBuilder.isEmpty()) {
            return;
        }
        JDA jda = this.plugin.getJDA();
        if (jda == null || jda.getStatus() != JDA.Status.CONNECTED) {
            return;
        }
        TextChannel textChannel = jda.getTextChannelById(this.plugin.getConfig().CHANNELS.CONSOLE_CHANNEL);
        if (textChannel == null) {
            return;
        }
        try {
            this.messageBuilder.buildAll(new MessageBuilder.SplitPolicy[0]).forEach(m -> textChannel.sendMessage((Message)m).queue());
            this.messageBuilder = new MessageBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

