/*
 * Decompiled with CFR 0.152.
 */
package com.magitechserver.magibridge.util;

import com.google.common.collect.Iterables;
import com.magitechserver.magibridge.MagiBridge;
import com.magitechserver.magibridge.config.categories.Messages;
import com.magitechserver.magibridge.util.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;

public class TextHelper {
    private static final Pattern URL_PARSER = Pattern.compile("(?<url>(http(s)?://)?([A-Za-z0-9-]+\\.)+[A-Za-z0-9]{2,}\\S*)", 2);

    public static Text replaceLink(Text text) {
        Messages.Link linkConfig = MagiBridge.getInstance().getConfig().MESSAGES.LINK_FORMAT;
        List hover = linkConfig.HOVER.stream().map(Utils::toText).collect(Collectors.toList());
        Text hoverText = Text.joinWith((Text)Text.NEW_LINE, hover);
        Function<String, Text> toReplace = urlString -> {
            URL url = null;
            try {
                String urlStringWithHttp = urlString.startsWith("http") ? urlString : "http://" + urlString;
                url = new URL(urlStringWithHttp);
            }
            catch (MalformedURLException urlStringWithHttp) {
                // empty catch block
            }
            String format = linkConfig.FORMAT.replace("%url%", (CharSequence)urlString);
            if (linkConfig.limit_length && format.length() > linkConfig.max_length) {
                format = format.substring(0, linkConfig.max_length) + "...";
            }
            return Utils.toText(format).toBuilder().onHover((HoverAction)TextActions.showText((Text)hoverText)).onClick((ClickAction)(url != null ? TextActions.openUrl((URL)url) : null)).build();
        };
        return TextHelper.replace(URL_PARSER, text, toReplace, false);
    }

    public static Text replace(Text text, Text oldValue, Text newValue) {
        return TextHelper.replace(Pattern.compile(oldValue.toPlain(), 16), text, val -> newValue, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Text replace(Pattern pattern, Text thisText, Function<String, Text> toReplaceFunction, boolean lossy) {
        Text text = thisText.getChildren().isEmpty() ? thisText : thisText.toBuilder().removeAll().append((Collection)thisText.getChildren().stream().map(child -> TextHelper.replace(pattern, child, toReplaceFunction, lossy)).collect(Collectors.toList())).build();
        String plain = text.toPlainSingle();
        Matcher matcher = pattern.matcher(plain);
        if (!matcher.find()) {
            if (!lossy) return text;
            plain = text.toPlain();
            matcher = pattern.matcher(plain);
            if (!matcher.find()) return text;
            text = text.toBuilder().removeAll().build();
        }
        if (matcher.matches()) {
            return TextHelper.reformat(thisText, Text.builder()).append(new Text[]{toReplaceFunction.apply(plain)}).append((Collection)text.getChildren()).build();
        }
        Text.Builder builder = Text.builder();
        List<String> strs = Arrays.asList(pattern.split(plain, -1));
        for (String str : Iterables.limit(strs, (int)(strs.size() - 1))) {
            builder.append(new Text[]{Text.of((String)str)});
            builder.append(new Text[]{toReplaceFunction.apply(plain)});
        }
        builder.append(new Text[]{Text.of((String)strs.get(strs.size() - 1))}).append((Collection)text.getChildren());
        return TextHelper.reformat(thisText, builder).build();
    }

    static Text.Builder reformat(Text thisText, Text.Builder builder) {
        builder.format(thisText.getFormat());
        thisText.getClickAction().ifPresent(arg_0 -> ((Text.Builder)builder).onClick(arg_0));
        thisText.getShiftClickAction().ifPresent(arg_0 -> ((Text.Builder)builder).onShiftClick(arg_0));
        thisText.getHoverAction().ifPresent(arg_0 -> ((Text.Builder)builder).onHover(arg_0));
        return builder;
    }
}

