/*
 * Decompiled with CFR 0.152.
 */
package magibridge.net.dv8tion.jda.api.entities;

import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import magibridge.net.dv8tion.jda.api.JDA;
import magibridge.net.dv8tion.jda.api.entities.Category;
import magibridge.net.dv8tion.jda.api.entities.ChannelType;
import magibridge.net.dv8tion.jda.api.entities.Guild;
import magibridge.net.dv8tion.jda.api.entities.IPermissionHolder;
import magibridge.net.dv8tion.jda.api.entities.ISnowflake;
import magibridge.net.dv8tion.jda.api.entities.Invite;
import magibridge.net.dv8tion.jda.api.entities.Member;
import magibridge.net.dv8tion.jda.api.entities.PermissionOverride;
import magibridge.net.dv8tion.jda.api.managers.ChannelManager;
import magibridge.net.dv8tion.jda.api.requests.RestAction;
import magibridge.net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import magibridge.net.dv8tion.jda.api.requests.restaction.ChannelAction;
import magibridge.net.dv8tion.jda.api.requests.restaction.InviteAction;
import magibridge.net.dv8tion.jda.api.requests.restaction.PermissionOverrideAction;

public interface GuildChannel
extends ISnowflake,
Comparable<GuildChannel> {
    @Nonnull
    public ChannelType getType();

    @Nonnull
    public String getName();

    @Nonnull
    public Guild getGuild();

    @Nullable
    public Category getParent();

    @Nonnull
    public List<Member> getMembers();

    public int getPosition();

    public int getPositionRaw();

    @Nonnull
    public JDA getJDA();

    @Nullable
    public PermissionOverride getPermissionOverride(@Nonnull IPermissionHolder var1);

    @Nonnull
    public List<PermissionOverride> getPermissionOverrides();

    @Nonnull
    public List<PermissionOverride> getMemberPermissionOverrides();

    @Nonnull
    public List<PermissionOverride> getRolePermissionOverrides();

    public boolean isSynced();

    @Nonnull
    @CheckReturnValue
    public ChannelAction<? extends GuildChannel> createCopy(@Nonnull Guild var1);

    @Nonnull
    @CheckReturnValue
    default public ChannelAction<? extends GuildChannel> createCopy() {
        return this.createCopy(this.getGuild());
    }

    @Nonnull
    public ChannelManager getManager();

    @Nonnull
    @CheckReturnValue
    public AuditableRestAction<Void> delete();

    @Nonnull
    @CheckReturnValue
    public PermissionOverrideAction createPermissionOverride(@Nonnull IPermissionHolder var1);

    @Nonnull
    @CheckReturnValue
    public PermissionOverrideAction putPermissionOverride(@Nonnull IPermissionHolder var1);

    @Nonnull
    @CheckReturnValue
    default public PermissionOverrideAction upsertPermissionOverride(@Nonnull IPermissionHolder permissionHolder) {
        PermissionOverride override = this.getPermissionOverride(permissionHolder);
        if (override != null) {
            return override.getManager();
        }
        return this.putPermissionOverride(permissionHolder);
    }

    @Nonnull
    @CheckReturnValue
    public InviteAction createInvite();

    @Nonnull
    @CheckReturnValue
    public RestAction<List<Invite>> retrieveInvites();
}

