/*
 * Decompiled with CFR 0.152.
 */
package magibridge.net.dv8tion.jda.api.events.guild.override;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import magibridge.net.dv8tion.jda.api.JDA;
import magibridge.net.dv8tion.jda.api.entities.Category;
import magibridge.net.dv8tion.jda.api.entities.ChannelType;
import magibridge.net.dv8tion.jda.api.entities.GuildChannel;
import magibridge.net.dv8tion.jda.api.entities.IPermissionHolder;
import magibridge.net.dv8tion.jda.api.entities.Member;
import magibridge.net.dv8tion.jda.api.entities.PermissionOverride;
import magibridge.net.dv8tion.jda.api.entities.Role;
import magibridge.net.dv8tion.jda.api.entities.StoreChannel;
import magibridge.net.dv8tion.jda.api.entities.TextChannel;
import magibridge.net.dv8tion.jda.api.entities.VoiceChannel;
import magibridge.net.dv8tion.jda.api.events.guild.GenericGuildEvent;

public class GenericPermissionOverrideEvent
extends GenericGuildEvent {
    protected final GuildChannel channel;
    protected final PermissionOverride override;

    public GenericPermissionOverrideEvent(@Nonnull JDA api, long responseNumber, @Nonnull GuildChannel channel, @Nonnull PermissionOverride override) {
        super(api, responseNumber, channel.getGuild());
        this.channel = channel;
        this.override = override;
    }

    @Nonnull
    public ChannelType getChannelType() {
        return this.channel.getType();
    }

    @Nonnull
    public GuildChannel getChannel() {
        return this.channel;
    }

    @Nonnull
    public TextChannel getTextChannel() {
        if (this.channel instanceof TextChannel) {
            return (TextChannel)this.channel;
        }
        throw new IllegalStateException("This override is for a channel of type " + (Object)((Object)this.getChannelType()));
    }

    @Nonnull
    public VoiceChannel getVoiceChannel() {
        if (this.channel instanceof VoiceChannel) {
            return (VoiceChannel)this.channel;
        }
        throw new IllegalStateException("This override is for a channel of type " + (Object)((Object)this.getChannelType()));
    }

    @Nonnull
    public StoreChannel getStoreChannel() {
        if (this.channel instanceof StoreChannel) {
            return (StoreChannel)this.channel;
        }
        throw new IllegalStateException("This override is for a channel of type " + (Object)((Object)this.getChannelType()));
    }

    @Nonnull
    public Category getCategory() {
        if (this.channel instanceof Category) {
            return (Category)this.channel;
        }
        throw new IllegalStateException("This override is for a channel of type " + (Object)((Object)this.getChannelType()));
    }

    @Nonnull
    public PermissionOverride getPermissionOverride() {
        return this.override;
    }

    public boolean isRoleOverride() {
        return this.override.isRoleOverride();
    }

    public boolean isMemberOverride() {
        return this.override.isMemberOverride();
    }

    @Nullable
    public IPermissionHolder getPermissionHolder() {
        return this.isMemberOverride() ? this.override.getMember() : this.override.getRole();
    }

    @Nullable
    public Member getMember() {
        return this.override.getMember();
    }

    @Nullable
    public Role getRole() {
        return this.override.getRole();
    }
}

