/*
 * Decompiled with CFR 0.152.
 */
package magibridge.net.dv8tion.jda.internal.handle;

import magibridge.net.dv8tion.jda.api.entities.Role;
import magibridge.net.dv8tion.jda.api.events.role.RoleCreateEvent;
import magibridge.net.dv8tion.jda.api.utils.data.DataObject;
import magibridge.net.dv8tion.jda.internal.JDAImpl;
import magibridge.net.dv8tion.jda.internal.entities.GuildImpl;
import magibridge.net.dv8tion.jda.internal.handle.EventCache;
import magibridge.net.dv8tion.jda.internal.handle.SocketHandler;

public class GuildRoleCreateHandler
extends SocketHandler {
    public GuildRoleCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        long guildId = content.getLong("guild_id");
        if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
            return guildId;
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildById(guildId);
        if (guild == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.GUILD, guildId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("GUILD_ROLE_CREATE was received for a Guild that is not yet cached: {}", (Object)content);
            return null;
        }
        Role newRole = this.getJDA().getEntityBuilder().createRole(guild, content.getObject("role"), guild.getIdLong());
        this.getJDA().handleEvent(new RoleCreateEvent(this.getJDA(), this.responseNumber, newRole));
        return null;
    }
}

