/*
 * Decompiled with CFR 0.152.
 */
package magibridge.net.dv8tion.jda.internal.utils;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import magibridge.okhttp3.MediaType;
import magibridge.okhttp3.RequestBody;
import magibridge.okio.BufferedSink;
import magibridge.okio.BufferedSource;
import magibridge.okio.Okio;
import magibridge.okio.Source;

public class BufferedRequestBody
extends RequestBody {
    private final Source source;
    private final MediaType type;
    private byte[] data;

    public BufferedRequestBody(Source source, MediaType type) {
        this.source = source;
        this.type = type;
    }

    @Override
    @Nullable
    public MediaType contentType() {
        return this.type;
    }

    @Override
    public void writeTo(@Nonnull BufferedSink sink) throws IOException {
        if (this.data != null) {
            sink.write(this.data);
            return;
        }
        try (BufferedSource s = Okio.buffer(this.source);){
            this.data = s.readByteArray();
            sink.write(this.data);
        }
    }
}

