/*
 * Decompiled with CFR 0.152.
 */
package magibridge.org.apache.http.impl.conn;

import magibridge.org.apache.http.HttpResponse;
import magibridge.org.apache.http.HttpResponseFactory;
import magibridge.org.apache.http.annotation.Immutable;
import magibridge.org.apache.http.config.MessageConstraints;
import magibridge.org.apache.http.impl.DefaultHttpResponseFactory;
import magibridge.org.apache.http.impl.conn.DefaultHttpResponseParser;
import magibridge.org.apache.http.io.HttpMessageParser;
import magibridge.org.apache.http.io.HttpMessageParserFactory;
import magibridge.org.apache.http.io.SessionInputBuffer;
import magibridge.org.apache.http.message.BasicLineParser;
import magibridge.org.apache.http.message.LineParser;

@Immutable
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

