/*
 * Decompiled with CFR 0.152.
 */
package magibridge.org.apache.http.impl.conn;

import java.net.InetAddress;
import magibridge.org.apache.http.HttpException;
import magibridge.org.apache.http.HttpHost;
import magibridge.org.apache.http.HttpRequest;
import magibridge.org.apache.http.ProtocolException;
import magibridge.org.apache.http.annotation.Immutable;
import magibridge.org.apache.http.client.config.RequestConfig;
import magibridge.org.apache.http.client.protocol.HttpClientContext;
import magibridge.org.apache.http.conn.SchemePortResolver;
import magibridge.org.apache.http.conn.UnsupportedSchemeException;
import magibridge.org.apache.http.conn.routing.HttpRoute;
import magibridge.org.apache.http.conn.routing.HttpRoutePlanner;
import magibridge.org.apache.http.impl.conn.DefaultSchemePortResolver;
import magibridge.org.apache.http.protocol.HttpContext;
import magibridge.org.apache.http.util.Args;

@Immutable
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    @Override
    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        Args.notNull(request, "Request");
        if (host == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        InetAddress local = config.getLocalAddress();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, request, context);
        }
        if (host.getPort() <= 0) {
            try {
                target = new HttpHost(host.getHostName(), this.schemePortResolver.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        if (proxy == null) {
            return new HttpRoute(target, local, secure);
        }
        return new HttpRoute(target, local, proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return null;
    }
}

