/*
 * Decompiled with CFR 0.152.
 */
package magibridge.org.apache.http.impl.nio;

import magibridge.org.apache.http.HttpRequest;
import magibridge.org.apache.http.HttpResponse;
import magibridge.org.apache.http.HttpResponseFactory;
import magibridge.org.apache.http.annotation.Immutable;
import magibridge.org.apache.http.config.ConnectionConfig;
import magibridge.org.apache.http.entity.ContentLengthStrategy;
import magibridge.org.apache.http.impl.ConnSupport;
import magibridge.org.apache.http.impl.DefaultHttpResponseFactory;
import magibridge.org.apache.http.impl.nio.DefaultNHttpClientConnection;
import magibridge.org.apache.http.impl.nio.codecs.DefaultHttpResponseParserFactory;
import magibridge.org.apache.http.nio.NHttpConnectionFactory;
import magibridge.org.apache.http.nio.NHttpMessageParserFactory;
import magibridge.org.apache.http.nio.NHttpMessageWriterFactory;
import magibridge.org.apache.http.nio.reactor.IOSession;
import magibridge.org.apache.http.nio.util.ByteBufferAllocator;
import magibridge.org.apache.http.nio.util.HeapByteBufferAllocator;
import magibridge.org.apache.http.params.HttpParamConfig;
import magibridge.org.apache.http.params.HttpParams;
import magibridge.org.apache.http.util.Args;

@Immutable
public class DefaultNHttpClientConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpClientConnection> {
    public static final DefaultNHttpClientConnectionFactory INSTANCE = new DefaultNHttpClientConnectionFactory();
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final NHttpMessageParserFactory<HttpResponse> responseParserFactory;
    private final NHttpMessageWriterFactory<HttpRequest> requestWriterFactory;
    private final ByteBufferAllocator allocator;
    private final ConnectionConfig cconfig;

    @Deprecated
    public DefaultNHttpClientConnectionFactory(HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        Args.notNull(responseFactory, "HTTP response factory");
        Args.notNull(allocator, "Byte buffer allocator");
        Args.notNull(params, "HTTP parameters");
        this.allocator = allocator;
        this.incomingContentStrategy = null;
        this.outgoingContentStrategy = null;
        this.responseParserFactory = new DefaultHttpResponseParserFactory(null, responseFactory);
        this.requestWriterFactory = null;
        this.cconfig = HttpParamConfig.getConnectionConfig(params);
    }

    @Deprecated
    public DefaultNHttpClientConnectionFactory(HttpParams params) {
        this(DefaultHttpResponseFactory.INSTANCE, HeapByteBufferAllocator.INSTANCE, params);
    }

    public DefaultNHttpClientConnectionFactory(ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, ByteBufferAllocator allocator, ConnectionConfig cconfig) {
        this.incomingContentStrategy = incomingContentStrategy;
        this.outgoingContentStrategy = outgoingContentStrategy;
        this.responseParserFactory = responseParserFactory;
        this.requestWriterFactory = requestWriterFactory;
        this.allocator = allocator;
        this.cconfig = cconfig != null ? cconfig : ConnectionConfig.DEFAULT;
    }

    public DefaultNHttpClientConnectionFactory(NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, ByteBufferAllocator allocator, ConnectionConfig cconfig) {
        this(null, null, responseParserFactory, requestWriterFactory, allocator, cconfig);
    }

    public DefaultNHttpClientConnectionFactory(NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, ConnectionConfig cconfig) {
        this(null, null, responseParserFactory, requestWriterFactory, null, cconfig);
    }

    public DefaultNHttpClientConnectionFactory(ConnectionConfig cconfig) {
        this(null, null, null, null, null, cconfig);
    }

    public DefaultNHttpClientConnectionFactory() {
        this(null, null, null, null, null, null);
    }

    @Deprecated
    protected DefaultNHttpClientConnection createConnection(IOSession session, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        return new DefaultNHttpClientConnection(session, responseFactory, allocator, params);
    }

    @Override
    public DefaultNHttpClientConnection createConnection(IOSession session) {
        return new DefaultNHttpClientConnection(session, this.cconfig.getBufferSize(), this.cconfig.getFragmentSizeHint(), this.allocator, ConnSupport.createDecoder(this.cconfig), ConnSupport.createEncoder(this.cconfig), this.cconfig.getMessageConstraints(), this.incomingContentStrategy, this.outgoingContentStrategy, this.requestWriterFactory, this.responseParserFactory);
    }
}

