/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.config;

import com.google.common.collect.ImmutableMap;
import com.tictim.ceu.Ceu;
import com.tictim.ceu.config.CeuVoltageCategory;
import com.tictim.ceu.config.InfiniteEnergySourceSetting;
import com.tictim.ceu.enums.CeuType;
import com.tictim.ceu.enums.Energy;
import com.tictim.ceu.message.MessageConfigSync;
import com.tictim.ceu.util.Ratio;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public final class CeuConfig {
    static Configuration cfg;
    private static CeuConfig config;
    @Nullable
    private static CeuConfig configSynced;
    private final ImmutableMap<CeuType, CeuVoltageCategory> ceuSettings;
    private final InfiniteEnergySourceSetting infiniteEnergySource;
    private boolean exactVoltage;

    public static void load(FMLPreInitializationEvent event) {
        File fileRetro = new File(event.getModConfigurationDirectory(), "gregtech_ceu.cfg");
        Configuration retro = fileRetro.exists() ? new Configuration(fileRetro) : null;
        cfg = new Configuration(new File(event.getModConfigurationDirectory(), "ceu.cfg"));
        config = new CeuConfig(retro);
        cfg.save();
    }

    @SubscribeEvent
    public static void reregister(RegistryEvent.Register event) {
        configSynced = null;
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            Ceu.NET.sendTo((IMessage)new MessageConfigSync(), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("ceu")) {
            config = new CeuConfig(cfg);
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server != null) {
                for (EntityPlayerMP p : server.func_184103_al().func_181057_v()) {
                    Ceu.NET.sendTo((IMessage)new MessageConfigSync(), p);
                }
            }
            cfg.save();
        }
    }

    public static CeuConfig instance() {
        return configSynced == null ? config : configSynced;
    }

    public static CeuConfig dedicatedInstance() {
        return config;
    }

    public static void setSyncedConfig(@Nullable CeuConfig config) {
        configSynced = config;
    }

    static List<IConfigElement> collectProperties() {
        return Collections.singletonList(new ConfigElement(cfg.getCategory("general")));
    }

    public CeuConfig(@Nullable Configuration retro) {
        this.exactVoltage = cfg.get("general", "exactVoltage", false, "True if you want CEU & CEF to accept batteries with same voltage as CEU/CEF's. False if you want CEU & CEF to accept any tier of batteries.").getBoolean();
        ImmutableMap.Builder b = new ImmutableMap.Builder();
        for (CeuType type : CeuType.values()) {
            b.put((Object)type, (Object)new CeuVoltageCategory(retro, type));
        }
        this.ceuSettings = b.build();
        this.infiniteEnergySource = new InfiniteEnergySourceSetting();
    }

    public CeuConfig(NBTTagCompound nbt) {
        this.exactVoltage = nbt.func_74767_n("exactVoltage");
        ImmutableMap.Builder b = new ImmutableMap.Builder();
        for (CeuType type : CeuType.values()) {
            b.put((Object)type, (Object)new CeuVoltageCategory(nbt, type));
        }
        this.ceuSettings = b.build();
        this.infiniteEnergySource = new InfiniteEnergySourceSetting(nbt.func_74775_l("infiniteEnergySource"));
    }

    public boolean isDisabled(CeuType type, int tier) {
        return ((CeuVoltageCategory)this.ceuSettings.get((Object)type)).getSetting((int)tier).disable;
    }

    public Ratio getRatio(CeuType type, int tier) {
        return ((CeuVoltageCategory)this.ceuSettings.get((Object)type)).getSetting((int)tier).conversionRatio;
    }

    public boolean isEnergySourceDisabled(Energy e, boolean isEmitter) {
        return isEmitter ? this.isEnergyEmitterDisabled(e) : this.isEnergyReceiverDisabled(e);
    }

    public boolean isEnergyEmitterDisabled(Energy e) {
        return this.infiniteEnergySource.isEnergyEmitterDisabled(e);
    }

    public boolean isEnergyReceiverDisabled(Energy e) {
        return this.infiniteEnergySource.isEnergyReceiverDisabled(e);
    }

    public void serialize(NBTTagCompound nbt) {
        nbt.func_74757_a("exactVoltage", this.exactVoltage);
        for (CeuVoltageCategory category : this.ceuSettings.values()) {
            category.serialize(nbt);
        }
        NBTTagCompound subnbt = new NBTTagCompound();
        this.infiniteEnergySource.serialize(subnbt);
        nbt.func_74782_a("infiniteEnergySource", (NBTBase)subnbt);
    }

    public boolean permitOnlyExactVoltage() {
        return this.exactVoltage;
    }
}

