/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.util;

import com.tictim.ceu.enums.NumberType;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class Numbers {
    private static final BigInteger INT_LIMIT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger LONG_LIMIT = BigInteger.valueOf(Long.MAX_VALUE);

    private Numbers() {
    }

    public static int addWithOverflowCheck(int x, int y) {
        int r = x + y;
        return ((x ^ r) & (y ^ r)) < 0 ? (x < 0 ? Integer.MIN_VALUE : Integer.MAX_VALUE) : x + y;
    }

    public static long addWithOverflowCheck(long x, long y) {
        long r = x + y;
        return ((x ^ r) & (y ^ r)) < 0L ? (x < 0L ? Long.MIN_VALUE : Long.MAX_VALUE) : x + y;
    }

    public static Number addWithOverflowCheck(Number x, Number y) {
        switch (NumberType.of(x).bigger(NumberType.of(y))) {
            case INTEGER: {
                return Numbers.addWithOverflowCheck(x.intValue(), y.intValue());
            }
            case LONG: {
                return Numbers.addWithOverflowCheck(x.longValue(), y.longValue());
            }
            case BIG_INTEGER: {
                return ((BigInteger)x).add((BigInteger)y);
            }
            case DOUBLE: {
                return x.doubleValue() + y.doubleValue();
            }
            case BIG_DECIMAL: {
                return ((BigDecimal)x).add((BigDecimal)y);
            }
        }
        throw new IllegalStateException();
    }

    public static Number sub(Number a, Number b) {
        switch (NumberType.of(a).bigger(NumberType.of(b))) {
            case INTEGER: {
                return a.intValue() - b.intValue();
            }
            case LONG: {
                return a.longValue() - b.longValue();
            }
            case BIG_INTEGER: {
                return Numbers.toBigInteger(a).subtract(Numbers.toBigInteger(b));
            }
            case DOUBLE: {
                return a.doubleValue() - b.doubleValue();
            }
            case BIG_DECIMAL: {
                return Numbers.toBigDecimal(a).subtract(Numbers.toBigDecimal(b));
            }
        }
        throw new IllegalStateException();
    }

    public static long clamp(long value, long min, long max) {
        return value >= max ? max : (value <= min ? min : value);
    }

    public static BigInteger toBigInteger(Number n) {
        if (n instanceof BigDecimal || n instanceof Double) {
            throw new IllegalArgumentException("Couldn't cast decimal number format to BigInteger");
        }
        if (n instanceof BigInteger) {
            return (BigInteger)n;
        }
        return BigInteger.valueOf(n.longValue());
    }

    public static BigDecimal toBigDecimal(Number n) {
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        if (n instanceof BigInteger) {
            return new BigDecimal((BigInteger)n);
        }
        return new BigDecimal(n.toString());
    }

    public static int toInt(BigInteger i) {
        return i.compareTo(INT_LIMIT) > 0 ? Integer.MAX_VALUE : i.intValue();
    }

    public static long toLong(BigInteger i) {
        return i.compareTo(LONG_LIMIT) > 0 ? Long.MAX_VALUE : i.longValue();
    }

    public static int toInt(double d) {
        return d > 2.147483647E9 ? Integer.MAX_VALUE : (int)d;
    }

    public static long toLong(double d) {
        return d > 9.223372036854776E18 ? Long.MAX_VALUE : (long)d;
    }
}

