/*
 * Decompiled with CFR 0.152.
 */
package net.dirtcraft.plugin.nightvisiontoggle.Commands;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.dirtcraft.plugin.nightvisiontoggle.NightVisionToggle;
import net.dirtcraft.plugin.nightvisiontoggle.Utility;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.PotionEffectData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.effect.potion.PotionEffectTypes;
import org.spongepowered.api.entity.living.player.Player;

public class Toggle
implements CommandExecutor {
    private final NightVisionToggle main;

    public Toggle(NightVisionToggle main) {
        this.main = main;
        main.getLogger().warn("Registering Command Aliases for " + main.getContainer().getName() + " (" + String.join((CharSequence)", ", main.getAliases()) + ")");
    }

    public CommandResult execute(CommandSource source, CommandContext args) throws CommandException {
        if (!(source instanceof Player)) {
            throw new CommandException(Utility.format("&cOnly a player can toggle Night Vision!"));
        }
        Player player = (Player)source;
        boolean hasNightVision = player.get(Keys.POTION_EFFECTS).map(Collection::stream).map(s -> s.map(PotionEffect::getType)).map(s -> s.anyMatch(PotionEffectTypes.NIGHT_VISION::equals)).filter(a -> a).isPresent();
        if (!hasNightVision) {
            PotionEffect nightVision = PotionEffect.builder().amplifier(0).duration(Integer.MAX_VALUE).potionType(PotionEffectTypes.NIGHT_VISION).build();
            player.getOrCreate(PotionEffectData.class).ifPresent(potionEffectData -> player.offer((ValueContainer)potionEffectData.addElement((Object)nightVision)));
            player.sendMessage(Utility.format("&7You have &aactivated &dNight Vision"));
        } else {
            Optional optionalPotionEffects = player.get(Keys.POTION_EFFECTS);
            if (!optionalPotionEffects.isPresent()) {
                throw new CommandException(Utility.format("&cCould not remove Night Vision potion effect!"));
            }
            List potionEffects = (List)optionalPotionEffects.get();
            potionEffects.removeIf(effect -> effect.getType() == PotionEffectTypes.NIGHT_VISION);
            player.offer(Keys.POTION_EFFECTS, (Object)potionEffects);
            player.sendMessage(Utility.format("&7You have &cdeactivated &dNight Vision"));
        }
        return CommandResult.success();
    }
}

