/*
 * Decompiled with CFR 0.152.
 */
package net.dirtcraft.plugin.nightvisiontoggle;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.dirtcraft.plugin.nightvisiontoggle.Commands.Toggle;
import net.dirtcraft.plugin.nightvisiontoggle.Utility;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;

@Plugin(id="night-vision-toggle", name="Night Vision Toggle", description="Simple Night Vision toggle plugin for Sponge", url="https://dirtcraft.net/", authors={"juliann"})
public class NightVisionToggle {
    @Inject
    private Logger logger;
    @Inject
    private PluginContainer container;
    private List<String> aliases = new ArrayList<String>(){
        {
            this.add("nightvision");
            this.add("vision");
            this.add("nv");
        }
    };

    @Listener
    public void onGameInit(GameInitializationEvent event) {
        CommandSpec toggle = CommandSpec.builder().permission("nightvisiontoggle.base").executor((CommandExecutor)new Toggle(this)).description(Utility.format("Toggle command for Night Vision")).build();
        Sponge.getCommandManager().register((Object)this, (CommandCallable)toggle, this.aliases);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public PluginContainer getContainer() {
        return this.container;
    }

    public List<String> getAliases() {
        return Collections.unmodifiableList(this.aliases);
    }
}

