/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.registry.RegistrySimple;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.zarathul.simplefluidtanks.SimpleFluidTanks;
import net.zarathul.simplefluidtanks.configuration.Config;
import net.zarathul.simplefluidtanks.rendering.BakedTankFluidModel;
import net.zarathul.simplefluidtanks.rendering.BakedTankModel;

public final class ClientEventHub {
    @SubscribeEvent
    public void OnConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("simplefluidtanks".equals(event.getModID())) {
            Config.sync();
        }
    }

    @SubscribeEvent
    public void OnModelRegistration(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)SimpleFluidTanks.tankItem, (int)0, (ModelResourceLocation)new ModelResourceLocation(SimpleFluidTanks.tankItem.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)SimpleFluidTanks.valveItem, (int)0, (ModelResourceLocation)new ModelResourceLocation(SimpleFluidTanks.valveItem.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)SimpleFluidTanks.wrenchItem, (int)0, (ModelResourceLocation)new ModelResourceLocation(SimpleFluidTanks.wrenchItem.getRegistryName(), "inventory"));
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        for (Map.Entry entry : FluidRegistry.getRegisteredFluids().entrySet()) {
            Fluid fluid = (Fluid)entry.getValue();
            IBakedModel[] bakedFluidModels = new IBakedModel[16];
            for (int x = 0; x < 16; ++x) {
                bakedFluidModels[x] = new BakedTankFluidModel(fluid, x + 1);
            }
            BakedTankModel.FLUID_MODELS.put((String)entry.getKey(), bakedFluidModels);
        }
        RegistrySimple registry = (RegistrySimple)event.getModelRegistry();
        ArrayList modelLocations = Lists.newArrayList();
        String modelPath = "tankBlock".toLowerCase();
        for (ModelResourceLocation modelLoc : registry.func_148742_b()) {
            if (!modelLoc.func_110624_b().equals("simplefluidtanks") || !modelLoc.func_110623_a().equals(modelPath) || modelLoc.func_177518_c().equals("inventory")) continue;
            modelLocations.add(modelLoc);
        }
        for (ModelResourceLocation loc : modelLocations) {
            IBakedModel registeredModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)loc);
            BakedTankModel replacementModel = new BakedTankModel(registeredModel);
            event.getModelRegistry().func_82595_a((Object)loc, (Object)replacementModel);
        }
    }
}

