/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.zarathul.simplefluidtanks.SimpleFluidTanks;
import net.zarathul.simplefluidtanks.blocks.TankBlock;
import net.zarathul.simplefluidtanks.blocks.ValveBlock;
import net.zarathul.simplefluidtanks.common.Utils;
import net.zarathul.simplefluidtanks.items.TankItem;
import net.zarathul.simplefluidtanks.items.ValveItem;
import net.zarathul.simplefluidtanks.items.WrenchItem;
import net.zarathul.simplefluidtanks.tileentities.TankBlockEntity;
import net.zarathul.simplefluidtanks.tileentities.ValveBlockEntity;

public final class CommonEventHub {
    private static final String TANKBLOCK_ENTITY_KEY = "simplefluidtanks:tankBlockEntity";
    private static final String VALVEBLOCK_ENTITY_KEY = "simplefluidtanks:valveBlockEntity";

    @SubscribeEvent
    public void OnBlockRegistration(RegistryEvent.Register<Block> event) {
        SimpleFluidTanks.tankBlock = new TankBlock();
        SimpleFluidTanks.valveBlock = new ValveBlock();
        GameRegistry.registerTileEntity(TankBlockEntity.class, (String)TANKBLOCK_ENTITY_KEY);
        GameRegistry.registerTileEntity(ValveBlockEntity.class, (String)VALVEBLOCK_ENTITY_KEY);
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{SimpleFluidTanks.tankBlock, SimpleFluidTanks.valveBlock});
    }

    @SubscribeEvent
    public void OnItemRegistration(RegistryEvent.Register<Item> event) {
        SimpleFluidTanks.tankItem = new TankItem(SimpleFluidTanks.tankBlock);
        SimpleFluidTanks.valveItem = new ValveItem(SimpleFluidTanks.valveBlock);
        SimpleFluidTanks.wrenchItem = new WrenchItem();
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{SimpleFluidTanks.tankItem, SimpleFluidTanks.valveItem, SimpleFluidTanks.wrenchItem});
    }

    @SubscribeEvent
    public void OnPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        TileEntity tile = player.func_130014_f_().func_175726_f(event.getPos()).func_177424_a(event.getPos(), Chunk.EnumCreateEntityType.CHECK);
        boolean tileIsTankComponent = tile instanceof TankBlockEntity || tile instanceof ValveBlockEntity;
        ItemStack heldItemStack = event.getItemStack();
        if (heldItemStack.func_190926_b()) {
            return;
        }
        if (tileIsTankComponent && Utils.isWrenchItem(heldItemStack.func_77973_b()) && player.func_70093_af()) {
            event.setUseBlock(Event.Result.ALLOW);
            event.setUseItem(Event.Result.DENY);
        }
    }
}

