/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.zarathul.simplefluidtanks.SimpleFluidTanks;
import net.zarathul.simplefluidtanks.blocks.TankMaterial;
import net.zarathul.simplefluidtanks.blocks.WrenchableBlock;
import net.zarathul.simplefluidtanks.common.Utils;
import net.zarathul.simplefluidtanks.configuration.Config;
import net.zarathul.simplefluidtanks.tileentities.ValveBlockEntity;

public class ValveBlock
extends WrenchableBlock {
    public static final PropertyInteger DOWN = PropertyInteger.func_177719_a((String)"down", (int)0, (int)2);
    public static final PropertyInteger UP = PropertyInteger.func_177719_a((String)"up", (int)0, (int)2);
    public static final PropertyInteger NORTH = PropertyInteger.func_177719_a((String)"north", (int)0, (int)2);
    public static final PropertyInteger SOUTH = PropertyInteger.func_177719_a((String)"south", (int)0, (int)2);
    public static final PropertyInteger WEST = PropertyInteger.func_177719_a((String)"west", (int)0, (int)2);
    public static final PropertyInteger EAST = PropertyInteger.func_177719_a((String)"east", (int)0, (int)2);
    private static final int GRATE_TEXTURE_ID = 0;
    private static final int IO_TEXTURE_ID = 1;
    private static final int TANK_TEXTURE_ID = 2;

    public ValveBlock() {
        super(TankMaterial.tankMaterial);
        this.setRegistryName("valveBlock");
        this.func_149663_c("valveBlock");
        this.func_149647_a(SimpleFluidTanks.creativeTab);
        this.func_149711_c(Config.valveBlockHardness);
        this.func_149752_b(Config.valveBlockResistance);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 2);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)UP, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)NORTH, (Comparable)Integer.valueOf(1)));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new ValveBlockEntity();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        ValveBlockEntity valveEntity = Utils.getTileEntityAt(world, ValveBlockEntity.class, pos);
        if (valveEntity != null) {
            if (valveEntity.hasTanks()) {
                state = state.func_177226_a((IProperty)DOWN, (Comparable)Integer.valueOf(valveEntity.isFacingTank(EnumFacing.DOWN) ? 0 : 1)).func_177226_a((IProperty)UP, (Comparable)Integer.valueOf(valveEntity.isFacingTank(EnumFacing.UP) ? 0 : 1)).func_177226_a((IProperty)NORTH, (Comparable)Integer.valueOf(valveEntity.isFacingTank(EnumFacing.NORTH) ? 0 : 1)).func_177226_a((IProperty)SOUTH, (Comparable)Integer.valueOf(valveEntity.isFacingTank(EnumFacing.SOUTH) ? 0 : 1)).func_177226_a((IProperty)WEST, (Comparable)Integer.valueOf(valveEntity.isFacingTank(EnumFacing.WEST) ? 0 : 1)).func_177226_a((IProperty)EAST, (Comparable)Integer.valueOf(valveEntity.isFacingTank(EnumFacing.EAST) ? 0 : 1));
            } else {
                EnumFacing facing = valveEntity.getFacing();
                state = state.func_177226_a((IProperty)DOWN, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)UP, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)NORTH, (Comparable)Integer.valueOf(facing == EnumFacing.NORTH ? 1 : 2)).func_177226_a((IProperty)SOUTH, (Comparable)Integer.valueOf(facing == EnumFacing.SOUTH ? 1 : 2)).func_177226_a((IProperty)WEST, (Comparable)Integer.valueOf(facing == EnumFacing.WEST ? 1 : 2)).func_177226_a((IProperty)EAST, (Comparable)Integer.valueOf(facing == EnumFacing.EAST ? 1 : 2));
            }
        }
        return state;
    }

    public boolean func_149698_L() {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack items) {
        super.func_180633_a(world, pos, state, placer, items);
        if (!world.field_72995_K) {
            EnumFacing facing = placer.func_174811_aO().func_176734_d();
            ValveBlockEntity valveEntity = Utils.getTileEntityAt((IBlockAccess)world, ValveBlockEntity.class, pos);
            if (valveEntity != null) {
                valveEntity.setFacing(facing);
                world.func_175646_b(pos, (TileEntity)valveEntity);
                world.func_184138_a(pos, state, state, 3);
            }
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        ValveBlockEntity valveEntity;
        if (!world.field_72995_K && (valveEntity = Utils.getTileEntityAt((IBlockAccess)world, ValveBlockEntity.class, pos)) != null) {
            valveEntity.formMultiblock();
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        IFluidHandler handler;
        ValveBlockEntity valveEntity;
        if (!world.field_72995_K && (valveEntity = Utils.getTileEntityAt((IBlockAccess)world, ValveBlockEntity.class, pos)) != null && (handler = (IFluidHandler)valveEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) != null) {
            FluidStack tankFluidBefore;
            FluidStack fluidStack = tankFluidBefore = valveEntity.getFluidAmount() > 0 ? valveEntity.getFluid().copy() : null;
            if (FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)handler)) {
                SoundEvent soundevent = tankFluidBefore == null || tankFluidBefore.amount < valveEntity.getFluidAmount() ? valveEntity.getFluid().getFluid().getEmptySound() : tankFluidBefore.getFluid().getFillSound();
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(soundevent, player.func_184176_by(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, 1.0f));
            }
        }
        if (FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)) != null) {
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 1;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        ValveBlockEntity valveEntity = Utils.getTileEntityAt((IBlockAccess)world, ValveBlockEntity.class, pos);
        if (valveEntity != null) {
            float fluidAmount = valveEntity.getFluidAmount();
            float capacity = valveEntity.getCapacity();
            int signalStrength = Utils.getComparatorLevel(fluidAmount, capacity);
            return signalStrength;
        }
        return 0;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        ValveBlockEntity valveEntity;
        if (!world.field_72995_K && (valveEntity = Utils.getTileEntityAt((IBlockAccess)world, ValveBlockEntity.class, pos)) != null) {
            valveEntity.disbandMultiblock();
        }
    }

    @Override
    protected void handleToolWrenchClick(World world, BlockPos pos, EntityPlayer player, ItemStack equippedItemStack) {
        ValveBlockEntity valveEntity = Utils.getTileEntityAt((IBlockAccess)world, ValveBlockEntity.class, pos);
        if (player.func_70093_af()) {
            if (valveEntity != null) {
                valveEntity.disbandMultiblock();
            }
            world.func_175698_g(pos);
            this.func_176226_b(world, pos, this.func_176223_P(), 0);
        } else if (valveEntity != null) {
            valveEntity.formMultiblock();
        }
    }
}

