/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.PriorityQueue;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class BasicAStar {
    private final PriorityQueue<Node> unvisitedNodes = new PriorityQueue();
    private final HashSet<BlockPos> visitedBlocks = new HashSet();
    private final HashMap<BlockPos, Integer> minCosts = new HashMap();
    private HashSet<BlockPos> passableBlocks;

    public BasicAStar() {
    }

    public BasicAStar(Collection<BlockPos> passableBlocks) {
        this();
        this.passableBlocks = new HashSet<BlockPos>(passableBlocks);
    }

    public Node getShortestPath(BlockPos start, BlockPos goal) {
        if (start == null || goal == null) {
            return null;
        }
        this.visitedBlocks.clear();
        this.unvisitedNodes.clear();
        this.minCosts.clear();
        Node currentNode = new Node();
        currentNode.block = start;
        this.computeCosts(currentNode, goal);
        this.unvisitedNodes.offer(currentNode);
        while (!currentNode.block.equals((Object)goal) && !this.unvisitedNodes.isEmpty()) {
            currentNode = this.unvisitedNodes.poll();
            this.visitedBlocks.add(currentNode.block);
            this.getAdjacentNodes(currentNode, goal);
        }
        return currentNode.block.equals((Object)goal) ? currentNode : null;
    }

    public void setPassableBlocks(Collection<BlockPos> passableBlocks) {
        this.passableBlocks = new HashSet<BlockPos>(passableBlocks);
    }

    private void computeCosts(Node node, BlockPos goal) {
        int currentCost = node.hasParent() ? node.parent.currentCost + this.getMovementCost(node.parent.block, node.block) : 0;
        int estimatedRemainingCost = this.getEstimatedRemainingCost(node.block, goal);
        node.currentCost = currentCost;
        node.estimatedTotalCost = currentCost + estimatedRemainingCost;
    }

    private int getEstimatedRemainingCost(BlockPos start, BlockPos goal) {
        int dx = Math.abs(start.func_177958_n() - goal.func_177958_n());
        int dy = Math.abs(start.func_177956_o() - goal.func_177956_o());
        return dx + dy;
    }

    private int getMovementCost(BlockPos from, BlockPos to) {
        if (from.equals((Object)to)) {
            return 0;
        }
        if (this.passableBlocks.contains(to)) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private void getAdjacentNodes(Node node, BlockPos goal) {
        BlockPos[] neighborBlocks;
        for (BlockPos neighborBlock : neighborBlocks = new BlockPos[]{node.block.func_177972_a(EnumFacing.EAST), node.block.func_177972_a(EnumFacing.WEST), node.block.func_177972_a(EnumFacing.SOUTH), node.block.func_177972_a(EnumFacing.NORTH)}) {
            if (!this.passableBlocks.contains(neighborBlock) || this.visitedBlocks.contains(neighborBlock)) continue;
            Node newNode = new Node();
            newNode.block = neighborBlock;
            newNode.parent = node;
            this.computeCosts(newNode, goal);
            Integer minCost = this.minCosts.get(newNode.block);
            if (minCost != null && newNode.currentCost < minCost) {
                this.unvisitedNodes.remove(newNode);
                minCost = null;
            }
            if (minCost != null) continue;
            this.unvisitedNodes.offer(newNode);
            this.minCosts.put(newNode.block, newNode.currentCost);
        }
    }

    public class Node
    implements Comparable<Node> {
        public int currentCost;
        public int estimatedTotalCost;
        public BlockPos block;
        public Node parent;

        public Node() {
            this.currentCost = 0;
            this.estimatedTotalCost = 0;
            this.block = null;
            this.parent = null;
        }

        public Node(Node other) {
            this.currentCost = other.currentCost;
            this.estimatedTotalCost = other.estimatedTotalCost;
            this.block = other.block;
            this.parent = other.parent;
        }

        public boolean hasParent() {
            return this.parent != null;
        }

        private Node first() {
            Node currentNode = this;
            while (currentNode.parent != null) {
                currentNode = currentNode.parent;
            }
            return currentNode;
        }

        @Override
        public int compareTo(Node other) {
            return Integer.compare(this.estimatedTotalCost, other.estimatedTotalCost);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.block == null ? 0 : this.block.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Node)) {
                return false;
            }
            Node other = (Node)obj;
            return !(this.block == null ? other.block != null : !this.block.equals((Object)other.block));
        }
    }
}

