/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.common;

import appeng.api.implementations.items.IAEWrench;
import blusunrize.immersiveengineering.api.tool.ITool;
import cofh.api.item.IToolHammer;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.zarathul.simplefluidtanks.SimpleFluidTanks;
import net.zarathul.simplefluidtanks.tileentities.TankBlockEntity;
import net.zarathul.simplefluidtanks.tileentities.ValveBlockEntity;

public final class Utils {
    private static final Predicate<String> stringNotNullOrEmpty = new Predicate<String>(){

        public boolean apply(String item) {
            return !Strings.isNullOrEmpty((String)item);
        }
    };
    private static final int FACTOR = 1000;
    private static final double FACTOR_LOG = Math.log(1000.0);
    private static final char[] METRIC_SUFFIXES = new char[]{'k', 'M', 'G', 'T', 'P', 'E'};
    private static HashMap<String, Boolean> InterfaceLookupCache = new HashMap();

    public static final <T extends TileEntity> T getTileEntityAt(IBlockAccess access, Class<T> tileType, BlockPos pos) {
        if (access != null && tileType != null && pos != null) {
            TileEntity tile;
            TileEntity tileEntity = tile = access instanceof ChunkCache ? ((ChunkCache)access).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : access.func_175625_s(pos);
            if (tile != null && tile.getClass() == tileType) {
                return (T)tile;
            }
        }
        return null;
    }

    public static final void syncBlockAndRerender(World world, BlockPos pos) {
        if (world == null || pos == null) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        world.markAndNotifyBlock(pos, null, state, state, 2);
    }

    public static ValveBlockEntity getValve(IBlockAccess world, BlockPos pos) {
        TankBlockEntity tankEntity;
        if (world != null && pos != null && (tankEntity = Utils.getTileEntityAt(world, TankBlockEntity.class, pos)) != null) {
            ValveBlockEntity valveEntity = tankEntity.getValve();
            return valveEntity;
        }
        return null;
    }

    public static final boolean notNullorEmpty(Iterable<String> items) {
        return Iterables.all(items, stringNotNullOrEmpty);
    }

    public static final ArrayList<String> multiLineTranslateToLocal(String key, Object ... args) {
        ArrayList<String> lines = new ArrayList<String>();
        if (key != null) {
            int x = 0;
            String currentKey = key + x;
            while (I18n.func_94522_b((String)currentKey)) {
                lines.add(I18n.func_74837_a((String)currentKey, (Object[])args));
                currentKey = key + ++x;
            }
        }
        return lines;
    }

    public static int getFluidLevel(int fillPercentage) {
        int level = (int)Math.round((double)fillPercentage / 100.0 * 16.0);
        return fillPercentage > 0 ? Math.max(1, level) : 0;
    }

    public static int getComparatorLevel(float numerator, float denominator) {
        int level = denominator != 0.0f ? (int)Math.floor(numerator / denominator * 14.0f) + (numerator > 0.0f ? 1 : 0) : 0;
        return level;
    }

    public static String getMetricFormattedNumber(long number, String shortFormat, String longFormat, Locale locale, Object misc) {
        if (shortFormat == null || longFormat == null || locale == null) {
            return null;
        }
        if (number < 1000L) {
            return String.format(locale, longFormat, number, misc);
        }
        int exponent = (int)(Math.log(number) / FACTOR_LOG);
        return String.format(locale, shortFormat, (double)number / Math.pow(1000.0, exponent), Character.valueOf(METRIC_SUFFIXES[exponent - 1]), misc);
    }

    public static String getMetricFormattedNumber(long number, String shortFormat, String longFormat, Object misc) {
        return Utils.getMetricFormattedNumber(number, shortFormat, longFormat, Locale.UK, misc);
    }

    public static boolean isInterfaceAvailable(String packageName, String interfaceName) {
        String FullyQualifiedName = packageName + "." + interfaceName;
        if (InterfaceLookupCache.containsKey(FullyQualifiedName)) {
            return InterfaceLookupCache.get(FullyQualifiedName);
        }
        try {
            Class<?> Interface2 = Class.forName(FullyQualifiedName);
            InterfaceLookupCache.put(FullyQualifiedName, true);
            return true;
        }
        catch (Exception e) {
            InterfaceLookupCache.put(FullyQualifiedName, false);
            return false;
        }
    }

    public static boolean isWrenchItem(Item item) {
        return item == SimpleFluidTanks.wrenchItem || Utils.isInterfaceAvailable("cofh.api.item", "IToolHammer") && item instanceof IToolHammer || Utils.isInterfaceAvailable("blusunrize.immersiveengineering.api.tool", "ITool") && item instanceof ITool || Utils.isInterfaceAvailable("appeng.api.implementations.items", "IAEWrench") && item instanceof IAEWrench;
    }
}

