/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.configuration;

import java.io.File;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public final class Config {
    private static Configuration config = null;
    private static final int defaultBucketsPerTank = 32;
    private static final boolean defaultWrenchEnabled = true;
    private static final float defaultTankBlockHardness = 50.0f;
    private static final float defaultTankBlockResistance = 1000.0f;
    private static final float defaultValveBlockHardness = 50.0f;
    private static final float defaultValveBlockResistance = 1000.0f;
    public static int bucketsPerTank;
    public static boolean wrenchEnabled;
    public static float tankBlockHardness;
    public static float tankBlockResistance;
    public static float valveBlockHardness;
    public static float valveBlockResistance;
    public static final String CATEGORY_MISC = "general.misc";
    public static final String CATEGORY_BLOCKS = "general.blocks";
    private static final String CATEGORY_BLOCKS_TANKBLOCK = "general.blocks.tank";
    private static final String CATEGORY_BLOCKS_VALVEBLOCK = "general.blocks.valve";

    public static final Configuration getConfig() {
        return config;
    }

    public static final void load(File configFile) {
        config = new Configuration(configFile);
        config.load();
        Config.sync();
    }

    public static void sync() {
        config.getCategory(CATEGORY_MISC).setLanguageKey("configui.category.misc").setComment(I18n.func_74838_a((String)"configui.category.misc.tooltip"));
        Property prop = config.get(CATEGORY_MISC, "bucketsPerTank", 32);
        prop.setComment(I18n.func_74838_a((String)"configui.bucketsPerTank.tooltip"));
        prop.setLanguageKey("configui.bucketsPerTank").setRequiresWorldRestart(true).setMinValue(1);
        bucketsPerTank = prop.getInt();
        prop = config.get(CATEGORY_MISC, "wrenchEnabled", true);
        prop.setComment(I18n.func_74838_a((String)"configui.wrenchEnabled.tooltip"));
        prop.setLanguageKey("configui.wrenchEnabled").setRequiresMcRestart(true);
        wrenchEnabled = prop.getBoolean();
        config.getCategory(CATEGORY_BLOCKS).setLanguageKey("configui.category.blocks").setComment(I18n.func_74838_a((String)"configui.category.blocks.tooltip"));
        config.getCategory(CATEGORY_BLOCKS_TANKBLOCK).setLanguageKey("configui.category.tank");
        config.getCategory(CATEGORY_BLOCKS_VALVEBLOCK).setLanguageKey("configui.category.valve");
        String blockHardnessKey = "hardness";
        String blockResistanceKey = "resistance";
        String blockHardnessComment = I18n.func_74838_a((String)"configui.blockHardness.tooltip");
        String blockResistanceComment = I18n.func_74838_a((String)"configui.blockResistance.tooltip");
        prop = config.get(CATEGORY_BLOCKS_TANKBLOCK, blockHardnessKey, 50.0, blockHardnessComment);
        prop.setLanguageKey("configui.blockHardness").setRequiresMcRestart(true).setMinValue(-1.0).setMaxValue(1000000.0);
        tankBlockHardness = (float)prop.getDouble();
        prop = config.get(CATEGORY_BLOCKS_TANKBLOCK, blockResistanceKey, 1000.0, blockResistanceComment);
        prop.setLanguageKey("configui.blockResistance").setRequiresMcRestart(true).setMinValue(1.0).setMaxValue(1000000.0);
        tankBlockResistance = (float)prop.getDouble();
        prop = config.get(CATEGORY_BLOCKS_VALVEBLOCK, blockHardnessKey, 50.0, blockHardnessComment);
        prop.setLanguageKey("configui.blockHardness").setRequiresMcRestart(true).setMinValue(-1.0).setMaxValue(1000000.0);
        valveBlockHardness = (float)prop.getDouble();
        prop = config.get(CATEGORY_BLOCKS_VALVEBLOCK, blockResistanceKey, 1000.0, blockResistanceComment);
        prop.setLanguageKey("configui.blockResistance").setRequiresMcRestart(true).setMinValue(1.0).setMaxValue(1000000.0);
        valveBlockResistance = (float)prop.getDouble();
        if (config.hasChanged()) {
            config.save();
        }
    }
}

