/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.theoneprobe;

import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.zarathul.simplefluidtanks.SimpleFluidTanks;
import net.zarathul.simplefluidtanks.common.Utils;
import net.zarathul.simplefluidtanks.configuration.Config;
import net.zarathul.simplefluidtanks.tileentities.TankBlockEntity;
import net.zarathul.simplefluidtanks.tileentities.ValveBlockEntity;

public class TankInfoProvider
implements IProbeInfoProvider {
    private static final String TANK_INFO = "tankInfo.";
    private static final String CAPACITY = "tankInfo.capacity";
    private static final String IS_LINKED = "tankInfo.isLinked";
    private static final String AMOUNT = "tankInfo.amount";
    private static final String TANKS = "tankInfo.tanks";
    private static final String YES = "tankInfo.yes";
    private static final String NO = "tankInfo.no";

    public String getID() {
        return "simplefluidtanks:TankInfoProvider";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        Block block = blockState.func_177230_c();
        if (block == SimpleFluidTanks.tankBlock && mode == ProbeMode.EXTENDED) {
            TankBlockEntity tankEntity = Utils.getTileEntityAt((IBlockAccess)world, TankBlockEntity.class, data.getPos());
            String readableFlag = I18n.func_74838_a((String)(tankEntity.isPartOfTank() ? YES : NO));
            probeInfo.text(I18n.func_74837_a((String)IS_LINKED, (Object[])new Object[]{readableFlag}));
            probeInfo.text(I18n.func_74837_a((String)CAPACITY, (Object[])new Object[]{Config.bucketsPerTank}));
        } else if (block == SimpleFluidTanks.valveBlock) {
            ValveBlockEntity valveEntity = Utils.getTileEntityAt((IBlockAccess)world, ValveBlockEntity.class, data.getPos());
            if (!valveEntity.hasTanks()) {
                return;
            }
            int amount = valveEntity.getFluidAmount();
            int capacity = valveEntity.getCapacity();
            int totalFillPercentage = capacity > 0 ? MathHelper.func_76125_a((int)((int)((long)amount * 100L / (long)capacity)), (int)0, (int)100) : 0;
            amount /= 1000;
            String suffix = "/ " + Utils.getMetricFormattedNumber(capacity /= 1000, "%.1f %s%s", "%d %s", "B");
            if (mode == ProbeMode.EXTENDED) {
                suffix = suffix + " (" + totalFillPercentage + "%)";
            }
            probeInfo.progress(amount, capacity, probeInfo.defaultProgressStyle().numberFormat(NumberFormat.COMPACT).filledColor(-14540067).alternateFilledColor(-14540067).suffix(suffix));
            if (amount > 0) {
                probeInfo.text(valveEntity.getLocalizedFluidName());
            }
            if (mode == ProbeMode.EXTENDED) {
                probeInfo.text(I18n.func_74837_a((String)AMOUNT, (Object[])new Object[]{amount}));
                probeInfo.text(I18n.func_74837_a((String)CAPACITY, (Object[])new Object[]{capacity}));
                probeInfo.text(I18n.func_74837_a((String)TANKS, (Object[])new Object[]{valveEntity.getLinkedTankCount()}));
            }
        }
    }
}

