/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.item;

import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.client.IModelRegister;

public class ItemPackage
extends Item
implements IPackageItem,
IModelRegister {
    public static final ItemPackage INSTANCE = new ItemPackage();
    public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation("packagedauto:package#inventory");

    protected ItemPackage() {
        this.setRegistryName("packagedauto:package");
        this.func_77655_b("packagedauto.package");
        this.func_77637_a(null);
    }

    public static ItemStack makePackage(IRecipeInfo recipeInfo, int index) {
        ItemStack stack = new ItemStack((Item)INSTANCE);
        NBTTagCompound tag = MiscUtil.writeRecipeToNBT(new NBTTagCompound(), recipeInfo);
        tag.func_74774_a("Index", (byte)index);
        stack.func_77982_d(tag);
        return stack;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        IRecipeInfo recipe = this.getRecipeInfo(stack);
        if (recipe != null) {
            tooltip.add(recipe.getRecipeType().getLocalizedName() + ": ");
            for (ItemStack is : recipe.getOutputs()) {
                tooltip.add(is.func_190916_E() + " " + is.func_82833_r());
            }
            int index = this.getIndex(stack);
            tooltip.add(I18n.func_74837_a((String)"item.packagedauto.package.index", (Object[])new Object[]{index}));
            tooltip.add(I18n.func_74838_a((String)"item.packagedauto.package.items"));
            List<ItemStack> recipeInputs = recipe.getInputs();
            List<ItemStack> packageItems = recipeInputs.subList(9 * index, Math.min(9 * index + 9, recipeInputs.size()));
            for (ItemStack is : packageItems) {
                tooltip.add(is.func_190916_E() + " " + is.func_82833_r());
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public IRecipeInfo getRecipeInfo(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            return MiscUtil.readRecipeFromNBT(tag);
        }
        return null;
    }

    @Override
    public int getIndex(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74771_c("Index");
        }
        return -1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)MODEL_LOCATION);
    }
}

