/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.morecauldrons.proxy;

import com.mrbysco.morecauldrons.MoreCauldrons;
import com.mrbysco.morecauldrons.blocks.inspirations.ICauldron;
import com.mrbysco.morecauldrons.init.ModBlocks;
import com.mrbysco.morecauldrons.init.ModItems;
import com.mrbysco.morecauldrons.proxy.CommonProxy;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.recipes.RecipesClientProxy;
import knightminer.inspirations.recipes.tileentity.TileCauldron;
import knightminer.inspirations.shared.client.TextureModel;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    @Override
    public void Preinit() {
        if (MoreCauldrons.inspirationsLoaded) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public void Init() {
    }

    @Optional.Method(modid="inspirations")
    @SubscribeEvent
    public void registerBlockColors(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        for (Block block : ModBlocks.BLOCKS) {
            if (!(block instanceof ICauldron)) continue;
            blockColors.func_186722_a((state, world, pos, tintIndex) -> {
                TileEntity te;
                if (tintIndex == 1 && (te = world.func_175625_s(pos)) instanceof TileCauldron) {
                    return ((TileCauldron)te).getColor();
                }
                return -1;
            }, new Block[]{block});
        }
    }

    @Optional.Method(modid="inspirations")
    protected static void replaceTexturedModel(ModelBakeEvent event, ModelResourceLocation location, String key, boolean item) {
        IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)location, (String)("Error loading model for " + location));
        IBakedModel standard = (IBakedModel)event.getModelRegistry().func_82594_a((Object)location);
        TextureModel finalModel = new TextureModel(standard, model, DefaultVertexFormats.field_176600_a, key, item);
        event.getModelRegistry().func_82595_a((Object)location, (Object)finalModel);
    }

    @Optional.Method(modid="inspirations")
    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        for (Block block : ModBlocks.BLOCKS) {
            if (block == null) {
                return;
            }
            boolean boiling = false;
            do {
                int i;
                ClientProxy.replaceTexturedModel(event, new ModelResourceLocation(ClientProxy.getBiggerResource(block.getRegistryName().func_110623_a(), "_inspirations"), String.format("boiling=%s,contents=fluid,level=empty", boiling)), "water", false);
                int n = i = Config.enableBiggerCauldron ? 0 : 1;
                while (i <= 3) {
                    ClientProxy.replaceTexturedModel(event, new ModelResourceLocation(ClientProxy.getBiggerResource(block.getRegistryName().func_110623_a(), "_inspirations"), String.format("boiling=%s,contents=fluid,level=%s", boiling, i)), "water", false);
                    ++i;
                }
            } while (boiling = !boiling);
        }
    }

    @SubscribeEvent
    public static void registerRenders(ModelRegistryEvent event) {
        for (Item item : ModItems.ITEMS) {
            if (MoreCauldrons.inspirationsLoaded) {
                ClientProxy.InspirationsBetterItem(event, item);
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
        for (Block block : ModBlocks.BLOCKS) {
            Item item = Item.func_150898_a((Block)block);
            if (MoreCauldrons.inspirationsLoaded) {
                ClientProxy.InspirationsBlockRender(event, block);
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    @Optional.Method(modid="inspirations")
    public static void InspirationsBlockRender(ModelRegistryEvent event, Block block) {
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new RecipesClientProxy.CauldronStateMapper(ClientProxy.getBiggerResource(block.getRegistryName().func_110623_a(), "_inspirations")));
    }

    @Optional.Method(modid="inspirations")
    public static void InspirationsBetterItem(ModelRegistryEvent event, Item item) {
        if (Config.betterCauldronItem) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(ClientProxy.getBiggerResource(item.getRegistryName().func_110623_a(), "_item"), "inventory"));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    public static ResourceLocation getBiggerResource(String input, String addition) {
        return new ResourceLocation("morecauldrons", input + addition);
    }
}

