/*
 * Decompiled with CFR 0.152.
 */
package com.me4502.slotmachines;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.me4502.slotmachines.FactorData;
import com.me4502.slotmachines.SlotTier;
import com.me4502.slotmachines.builder.FactorDataBuilder;
import com.me4502.slotmachines.builder.SlotTierBuilder;
import com.me4502.slotmachines.data.SlotMachineData;
import com.me4502.slotmachines.data.SlotMachineKeys;
import com.me4502.slotmachines.data.mutable.SlotMachineOwnerData;
import com.me4502.slotmachines.util.ConfigValue;
import com.me4502.slotmachines.util.LocationUtil;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.tileentity.Sign;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.hanging.ItemFrame;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.ProviderRegistration;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;

@Plugin(id="slotmachines", name="SlotMachines", description="SlotMachines for Sponge", authors={"Me4502"})
public class SlotMachines {
    @Inject
    private Logger logger;
    @Inject
    public PluginContainer container;
    @Inject
    @DefaultConfig(sharedRoot=false)
    private Path defaultConfig;
    @Inject
    @DefaultConfig(sharedRoot=false)
    private ConfigurationLoader<CommentedConfigurationNode> configManager;
    public static SlotMachines instance;
    public static final UUID ADMIN_UUID;
    private ConfigValue<List<ItemStack>> items = new ConfigValue<List<ItemStack>>("items", "The items that can appear on the slot machine", Lists.newArrayList((Object[])new ItemStack[]{ItemStack.of((ItemType)ItemTypes.GOLD_INGOT, (int)1), ItemStack.of((ItemType)ItemTypes.GOLDEN_APPLE, (int)1), ItemStack.of((ItemType)ItemTypes.DIAMOND_ORE, (int)1), ItemStack.of((ItemType)ItemTypes.EMERALD_ORE, (int)1), ItemStack.of((ItemType)ItemTypes.GOLD_ORE, (int)1), ItemStack.of((ItemType)ItemTypes.IRON_ORE, (int)1), ItemStack.of((ItemType)ItemTypes.COAL_ORE, (int)1), ItemStack.of((ItemType)ItemTypes.APPLE, (int)1), ItemStack.of((ItemType)ItemTypes.STICK, (int)1), ItemStack.of((ItemType)ItemTypes.FISH, (int)1), ItemStack.of((ItemType)ItemTypes.DIRT, (int)1)}), new TypeToken<List<ItemStack>>(){});
    private ConfigValue<List<FactorData>> factors = new ConfigValue<List<FactorData>>("factors", "The factors", Lists.newArrayList((Object[])new FactorData[]{new FactorData(ItemStack.of((ItemType)ItemTypes.GOLD_INGOT, (int)3), 1666.0), new FactorData(ItemStack.of((ItemType)ItemTypes.GOLDEN_APPLE, (int)3), 300.0), new FactorData(ItemStack.of((ItemType)ItemTypes.DIAMOND_ORE, (int)3), 100.0), new FactorData(ItemStack.of((ItemType)ItemTypes.EMERALD_ORE, (int)3), 50.0), new FactorData(ItemStack.of((ItemType)ItemTypes.GOLD_ORE, (int)3), 25.0), new FactorData(ItemStack.of((ItemType)ItemTypes.IRON_ORE, (int)3), 12.0), new FactorData(ItemStack.of((ItemType)ItemTypes.APPLE, (int)3), 12.0), new FactorData(ItemStack.of((ItemType)ItemTypes.APPLE, (int)2), 6.0), new FactorData(ItemStack.of((ItemType)ItemTypes.APPLE, (int)1), 1.0)}), new TypeToken<List<FactorData>>(){});
    private ConfigValue<List<SlotTier>> slotTiers = new ConfigValue<List<SlotTier>>("tiers", "The slot tiers", Lists.newArrayList((Object[])new SlotTier[]{new SlotTier((BlockState)BlockState.builder().blockType(BlockTypes.IRON_BLOCK).build(), 1.0), new SlotTier((BlockState)BlockState.builder().blockType(BlockTypes.GOLD_BLOCK).build(), 2.5), new SlotTier((BlockState)BlockState.builder().blockType(BlockTypes.DIAMOND_BLOCK).build(), 5.0)}), new TypeToken<List<SlotTier>>(){});
    private ConfigurationNode messagesNode;
    private ConfigurationNode defaultNode;
    private Set<Location<?>> lockedMachines = Sets.newHashSet();

    @Listener
    public void onServerStarting(GamePreInitializationEvent event) {
        instance = this;
        SlotMachineData.registerData();
        Sponge.getDataManager().registerBuilder(FactorData.class, (DataBuilder)new FactorDataBuilder());
        Sponge.getDataManager().registerBuilder(SlotTier.class, (DataBuilder)new SlotTierBuilder());
    }

    public void loadConfig() {
        URL jarConfigFile = this.getClass().getResource("messages.conf");
        ConfigurationOptions options = ConfigurationOptions.defaults().setShouldCopyDefaults(true);
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setURL(jarConfigFile)).setDefaultOptions(options)).build();
        HoconConfigurationLoader fileLoader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(new File(this.defaultConfig.toFile().getParentFile(), "messages.conf"))).setDefaultOptions(options)).build();
        try {
            this.messagesNode = fileLoader.load(options);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.defaultNode = loader.load(options);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ConfigurationNode node = this.configManager.load(options);
            this.items.load(node);
            this.factors.load(node);
            this.slotTiers.load(node);
            this.configManager.save(node);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Listener
    public void onServerStart(GameStartedServerEvent event) {
        this.loadConfig();
    }

    @Listener
    public void onPluginReload(GameReloadEvent event) {
        this.loadConfig();
    }

    @Listener
    public void onServerStopping(GameStoppingServerEvent event) {
        ConfigurationOptions options = ConfigurationOptions.defaults().setShouldCopyDefaults(true);
        HoconConfigurationLoader fileLoader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(new File(this.defaultConfig.toFile().getParentFile(), "messages.conf"))).setDefaultOptions(options)).build();
        try {
            fileLoader.save(this.messagesNode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Listener
    public void onEntityInteract(InteractEntityEvent event, @First Player player) {
        if (event.getTargetEntity() instanceof ItemFrame) {
            for (Location<?> location : this.lockedMachines) {
                if (!(location.getBlockPosition().distance(event.getTargetEntity().getLocation().getBlockPosition()) < 5.0f)) continue;
                event.setCancelled(true);
                break;
            }
        }
    }

    @Listener
    public void onInteract(InteractBlockEvent.Secondary.MainHand event, final @First Player player) {
        event.getTargetBlock().getLocation().filter(location -> location.getBlockType() == BlockTypes.STONE_BUTTON || location.getBlockType() == BlockTypes.WOODEN_BUTTON).ifPresent(location -> this.getTier(LocationUtil.getBackBlock(location)).ifPresent(slotTier -> {
            if (this.lockedMachines.contains(location)) {
                player.sendMessage(this.getMessage("slots.in-use"));
                return;
            }
            boolean failed = false;
            boolean message = false;
            Location newLocation = LocationUtil.getBackBlock(location);
            Direction xDirection = LocationUtil.getRight(location);
            Direction xOpposite = xDirection.getOpposite();
            Direction yDirection = Direction.UP;
            ArrayList<ItemFrame> arrayList = new ArrayList<ItemFrame>();
            Location lampLocation = null;
            Sign topLeftSign = null;
            Sign topRightSign = null;
            int y = 0;
            while (true) {
                if (y < 3 && !failed) {
                } else {
                    if (failed) {
                        if (!message) return;
                        player.sendMessage(this.getMessage("slots.invalid-slotmachine"));
                        return;
                    }
                    Cause.Builder causeBuilder = Cause.builder();
                    causeBuilder.append((Object)this.container);
                    final Cause cause = causeBuilder.build(EventContext.empty());
                    if (((Text)topLeftSign.lines().get(0)).equals((Object)this.getMessage("slots.sign.title"))) {
                        List list = Lists.reverse(arrayList);
                        final UUID ownerUUID = topRightSign.get(SlotMachineKeys.SLOT_MACHINE_OWNER).orElse(null);
                        if (ownerUUID == null) {
                            player.sendMessage(this.getMessage("slots.missing-data"));
                            return;
                        }
                        if (player.getUniqueId().equals(ownerUUID)) {
                            player.sendMessage(this.getMessage("slots.own-machine"));
                            return;
                        }
                        double price = 0.0;
                        try {
                            price = Double.parseDouble(LocationUtil.getTextRaw(topRightSign, 1));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (price <= 0.0) {
                            player.sendMessage(this.getMessage("slots.missing-price"));
                            return;
                        }
                        EconomyService economyService = (EconomyService)((ProviderRegistration)Sponge.getServiceManager().getRegistration(EconomyService.class).get()).getProvider();
                        double lowerLimit2 = 0.0;
                        try {
                            lowerLimit2 = Double.parseDouble(LocationUtil.getTextRaw(topRightSign, 3));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        lowerLimit2 = Math.max(lowerLimit2, 0.0);
                        double maxPrize = price * slotTier.getMultiplier() * this.getHighestFactor().getMultiplier();
                        final UniqueAccount ownerAccount = (UniqueAccount)economyService.getOrCreateAccount(ownerUUID).get();
                        if (!ownerUUID.equals(ADMIN_UUID) && ownerAccount.getBalance(economyService.getDefaultCurrency()).doubleValue() - maxPrize < lowerLimit2) {
                            player.sendMessage(this.getMessage("slots.out-of-money"));
                            return;
                        }
                        UniqueAccount account = (UniqueAccount)economyService.getOrCreateAccount(player.getUniqueId()).get();
                        if (account.withdraw(economyService.getDefaultCurrency(), BigDecimal.valueOf(price), cause).getResult() != ResultType.SUCCESS) {
                            double d = price;
                            player.sendMessage(this.getMessage("slots.insufficient-funds", string -> string.replace("{amount}", String.valueOf(d))));
                            return;
                        }
                        if (!ownerUUID.equals(ADMIN_UUID)) {
                            ownerAccount.deposit(economyService.getDefaultCurrency(), BigDecimal.valueOf(price), cause);
                        }
                        this.lockedMachines.add((Location<?>)location);
                        final List list2 = list;
                        final double finalPrice1 = price;
                        Sponge.getScheduler().createTaskBuilder().intervalTicks(8L).execute((Consumer)new Consumer<Task>(){
                            int startingFrame = 0;
                            int timeSinceChange = 0;

                            @Override
                            public void accept(Task task) {
                                if (this.startingFrame == list2.size()) {
                                    task.cancel();
                                    List results = list2.stream().map(itemFrame -> itemFrame.get(Keys.REPRESENTED_ITEM).orElse(null)).filter(Objects::nonNull).map(ItemStackSnapshot::createStack).collect(Collectors.toList());
                                    FactorData data = SlotMachines.this.getFactor(results).orElse(null);
                                    if (data == null) {
                                        player.sendMessage(SlotMachines.this.getMessage("slots.better-luck"));
                                    } else {
                                        double prize = finalPrice1 * slotTier.getMultiplier() * data.getMultiplier();
                                        player.sendMessage(SlotMachines.this.getMessage("slots.you-won", string -> string.replace("{prize}", String.valueOf(prize))));
                                        EconomyService economyService = (EconomyService)((ProviderRegistration)Sponge.getServiceManager().getRegistration(EconomyService.class).get()).getProvider();
                                        UniqueAccount account = (UniqueAccount)economyService.getOrCreateAccount(player.getUniqueId()).get();
                                        account.deposit(economyService.getDefaultCurrency(), BigDecimal.valueOf(prize), cause);
                                        if (!ownerUUID.equals(ADMIN_UUID)) {
                                            ownerAccount.withdraw(economyService.getDefaultCurrency(), BigDecimal.valueOf(prize), cause);
                                        }
                                    }
                                    Sponge.getScheduler().createTaskBuilder().delayTicks(60L).execute(task1 -> {
                                        list2.forEach(frame -> frame.remove(Keys.REPRESENTED_ITEM));
                                        SlotMachines.this.lockedMachines.remove(location);
                                    }).submit((Object)SlotMachines.this.container);
                                } else {
                                    for (int i = this.startingFrame; i < list2.size(); ++i) {
                                        ItemFrame frame = (ItemFrame)list2.get(i);
                                        frame.offer(Keys.REPRESENTED_ITEM, (Object)((ItemStack)((List)SlotMachines.this.items.getValue()).get(ThreadLocalRandom.current().nextInt(((List)SlotMachines.this.items.getValue()).size()))).createSnapshot());
                                        if (this.timeSinceChange >= 10 || this.timeSinceChange > 5 && ThreadLocalRandom.current().nextInt(5) == 0) {
                                            ++this.startingFrame;
                                            this.timeSinceChange = 0;
                                        }
                                        ++this.timeSinceChange;
                                    }
                                }
                            }
                        }).submit((Object)this.container);
                        topLeftSign.offer(Keys.SIGN_LINES, (Object)Lists.newArrayList((Object[])new Text[]{this.getMessage("slots.sign.title"), Text.EMPTY, this.getMessage("slots.sign.last-player"), Text.of((Object[])new Object[]{TextColors.DARK_RED, player.getName()})}));
                        return;
                    }
                    if (!player.hasPermission("slots.create")) {
                        player.sendMessage(this.getMessage("slots.permission.create"));
                        return;
                    }
                    double price = 0.0;
                    try {
                        price = Double.parseDouble(LocationUtil.getTextRaw(topRightSign, 0));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    double lowerLimit = 0.0;
                    try {
                        lowerLimit = Double.parseDouble(LocationUtil.getTextRaw(topRightSign, 3));
                    }
                    catch (Exception lowerLimit2) {
                        // empty catch block
                    }
                    lowerLimit = Math.max(0.0, lowerLimit);
                    if (price <= 0.0) {
                        player.sendMessage(this.getMessage("slots.missing-price"));
                        return;
                    }
                    double paymentPrice = price * slotTier.getMultiplier();
                    EconomyService economyService = (EconomyService)((ProviderRegistration)Sponge.getServiceManager().getRegistration(EconomyService.class).get()).getProvider();
                    UniqueAccount account = (UniqueAccount)economyService.getOrCreateAccount(player.getUniqueId()).get();
                    boolean isAdmin = ((Text)topLeftSign.lines().get(1)).toPlain().equals("ADMIN");
                    if (isAdmin && !player.hasPermission("slots.create.admin")) {
                        player.sendMessage(this.getMessage("slots.permission.admin"));
                        return;
                    }
                    if (!isAdmin && account.withdraw(economyService.getDefaultCurrency(), BigDecimal.valueOf(paymentPrice), cause).getResult() != ResultType.SUCCESS) {
                        player.sendMessage(this.getMessage("slots.insufficient-funds", string -> string.replace("{amount}", String.valueOf(paymentPrice))));
                        return;
                    }
                    topRightSign.offer(Keys.SIGN_LINES, (Object)Lists.newArrayList((Object[])new Text[]{this.getMessage("slots.sign.price"), Text.of((Object[])new Object[]{TextColors.RED, price}), this.getMessage("slots.sign.limit"), Text.of((Object[])new Object[]{TextColors.RED, lowerLimit})}));
                    topLeftSign.offer(Keys.SIGN_LINES, (Object)Lists.newArrayList((Object[])new Text[]{this.getMessage("slots.sign.title"), Text.EMPTY, Text.EMPTY, Text.EMPTY}));
                    SlotMachineOwnerData slotMachineOwnerData = new SlotMachineOwnerData(isAdmin ? ADMIN_UUID : player.getUniqueId());
                    topRightSign.offer((ValueContainer)slotMachineOwnerData);
                    return;
                }
                for (int x = 0; x < 3; newLocation = newLocation.getRelative(xDirection), ++x) {
                    Location frontLocation;
                    block33: {
                        frontLocation = newLocation.getRelative(LocationUtil.getFront(location));
                        if (x == 1 && y == 2) {
                            if (newLocation.getBlockType() != BlockTypes.REDSTONE_LAMP) {
                                failed = true;
                                this.logger.debug("Missing lamp. Got " + newLocation.getBlockType().getName() + " at " + newLocation.toString() + " Grid: " + x + "," + y);
                                break;
                            }
                            lampLocation = newLocation;
                        } else {
                            if (y == 1) {
                                ItemFrame frame = this.getItemFrame(frontLocation);
                                if (frame != null) {
                                    arrayList.add(frame);
                                    break block33;
                                } else {
                                    failed = true;
                                    this.logger.debug("Missing frame. Got " + frontLocation.getBlockType().getName() + " at " + frontLocation.toString() + " Grid: " + x + "," + y);
                                    break;
                                }
                            }
                            if (!newLocation.getBlock().equals(slotTier.getBlockState())) {
                                failed = true;
                                this.logger.debug("Missing tier. Got " + newLocation.getBlockType().getName() + " at " + newLocation.toString() + " Grid: " + x + "," + y);
                                break;
                            }
                        }
                    }
                    if (x == 0 && y == 2) {
                        topRightSign = frontLocation.getTileEntity().filter(tileEntity -> tileEntity instanceof Sign).orElse(null);
                        if (topRightSign != null) continue;
                        this.logger.debug("Missing right sign. Got " + frontLocation.getBlockType().getName() + " at " + frontLocation.toString() + " Grid: " + x + "," + y);
                        failed = true;
                        break;
                    }
                    if (x != 2 || y != 2 || (topLeftSign = (Sign)frontLocation.getTileEntity().filter(tileEntity -> tileEntity instanceof Sign).orElse(null)) != null) continue;
                    this.logger.debug("Missing left sign. Got " + frontLocation.getBlockType().getName() + " at " + frontLocation.toString() + " Grid: " + x + "," + y);
                    failed = true;
                    break;
                }
                newLocation = newLocation.getRelative(xOpposite).getRelative(xOpposite).getRelative(xOpposite).getRelative(yDirection);
                ++y;
            }
        }));
    }

    private ItemFrame getItemFrame(Location<?> location) {
        return location.getExtent().getEntities().stream().filter(entity -> entity.getLocation().getBlockPosition().equals((Object)location.getBlockPosition())).filter(entity -> entity.getType() == EntityTypes.ITEM_FRAME).map(entity -> (ItemFrame)entity).findFirst().orElse(null);
    }

    private Optional<SlotTier> getTier(Location<?> location) {
        return this.slotTiers.getValue().stream().filter(tier -> location.getBlock().equals(tier.getBlockState())).findFirst();
    }

    private Optional<FactorData> getFactor(List<ItemStack> results) {
        FactorData bestMatch = null;
        for (FactorData data : this.factors.getValue()) {
            if (!data.matches(results) || bestMatch != null && !(bestMatch.getMultiplier() < data.getMultiplier())) continue;
            bestMatch = data;
        }
        return Optional.ofNullable(bestMatch);
    }

    private FactorData getHighestFactor() {
        FactorData bestMatch = null;
        for (FactorData data : this.factors.getValue()) {
            if (bestMatch != null && !(bestMatch.getMultiplier() < data.getMultiplier())) continue;
            bestMatch = data;
        }
        return bestMatch;
    }

    private Text getMessage(String message) {
        Object[] path = message.split("\\.");
        return TextSerializers.FORMATTING_CODE.deserialize(this.messagesNode.getNode(path).getString(this.defaultNode.getNode(path).getString("Unknown Message: " + message)));
    }

    private Text getMessage(String message, Function<String, String> replacer) {
        Object[] path = message.split("\\.");
        String replaced = replacer.apply(this.messagesNode.getNode(path).getString(this.defaultNode.getNode(path).getString("Unknown Message: " + message)));
        return TextSerializers.FORMATTING_CODE.deserialize(replaced);
    }

    static {
        ADMIN_UUID = new UUID(0L, 0L);
    }
}

