/*
 * Decompiled with CFR 0.152.
 */
package com.me4502.slotmachines.util;

import com.google.common.reflect.TypeToken;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

public class ConfigValue<T> {
    private String key;
    private String comment;
    private T defaultValue;
    private T value;
    private TypeToken<T> typeToken;

    public ConfigValue(String key, String comment, T value) {
        this(key, comment, value, null);
    }

    public ConfigValue(String key, String comment, T value, TypeToken<T> typeToken) {
        this.key = key;
        this.comment = comment;
        this.defaultValue = value;
        this.typeToken = typeToken;
    }

    public ConfigValue<T> load(ConfigurationNode configurationNode) {
        this.value = this.getValueInternal(configurationNode);
        this.save(configurationNode);
        return this;
    }

    private ConfigValue<T> save(ConfigurationNode configurationNode) {
        this.setValueInternal(configurationNode);
        return this;
    }

    public T getValue() {
        if (this.value == null) {
            this.value = this.defaultValue;
        }
        return this.value;
    }

    private void setValueInternal(ConfigurationNode configurationNode) {
        ConfigurationNode node = configurationNode.getNode(new Object[]{this.key});
        if (this.comment != null && node instanceof CommentedConfigurationNode) {
            ((CommentedConfigurationNode)node).setComment(this.comment);
        }
        if (this.typeToken != null) {
            try {
                node.setValue(this.typeToken, this.value);
            }
            catch (ObjectMappingException e) {
                e.printStackTrace();
            }
        } else {
            node.setValue(this.value);
        }
    }

    private T getValueInternal(ConfigurationNode configurationNode) {
        ConfigurationNode node = configurationNode.getNode(new Object[]{this.key});
        if (this.comment != null && node instanceof CommentedConfigurationNode) {
            ((CommentedConfigurationNode)node).setComment(this.comment);
        }
        try {
            if (this.typeToken != null) {
                return (T)node.getValue(this.typeToken, this.defaultValue);
            }
            return (T)node.getValue(new TypeToken<T>(this.defaultValue.getClass()){}, this.defaultValue);
        }
        catch (Exception e) {
            return this.defaultValue;
        }
    }
}

